/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.uaa;

import cn.com.yusys.udp.cloud.commons.bean.UserInfo;
import cn.com.yusys.udp.cloud.gateway.config.UcgUaaAuthConfig;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.uaa.UcgUaaAuthChecker;
import cn.com.yusys.udp.cloud.gateway.util.UcgJwtUtils;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.auth0.jwt.interfaces.Claim;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class UcgUaaAuthRedisChecker
implements UcgUaaAuthChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RedisTemplate<String, String> redisTemplate;
    private final LoadingCache<String, String> tokenCache;

    public UcgUaaAuthRedisChecker(final RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.tokenCache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                String cache = (String)redisTemplate.opsForValue().get((Object)key);
                if (cache == null) {
                    return "";
                }
                return cache;
            }
        });
    }

    @Override
    public Map<String, String> checkToken(ServerHttpRequest request, UcgUaaAuthConfig config) {
        String token = this.getToken(request, config);
        if (token == null) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [UaaAuth] token not found");
        }
        String redisToken = (String)this.tokenCache.getUnchecked((Object)("access:" + token));
        if (redisToken == null || "".equals(redisToken)) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [UaaAuth] token {" + token + "} not found");
        }
        Map<String, Claim> claims = UcgJwtUtils.getClaims(token);
        if (claims == null) {
            this.logger.warn("[udp-cloud-gateway]: [UaaAuth] token {" + token + "} claims not found");
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>(4);
        String context = this.buildContext(claims, config.getSessionContextClass());
        if (context != null) {
            headers.put("Baggage-Session-Context", context);
        }
        return headers;
    }

    public String buildContext(Map<String, Claim> claims, String userKeyClass) {
        Claim organizationId;
        Claim clientId;
        UserInfo userInfo = new UserInfo();
        Claim userId = claims.get("user_id");
        if (userId != null) {
            userInfo.setUserId(userId.asString());
        }
        if ((clientId = claims.get("client_id")) != null) {
            userInfo.setClientId(clientId.asString());
        }
        if ((organizationId = claims.get("org_id")) != null) {
            userInfo.setOrganizationId(organizationId.asString());
        }
        Claim loginCode = claims.get("login_code");
        if (userId != null) {
            userInfo.setLoginCode(loginCode.asString());
        }
        return UcgUtils.buildBaggageSessionContext(userInfo, userKeyClass);
    }

    public String getToken(ServerHttpRequest request, UcgUaaAuthConfig config) {
        String token = request.getHeaders().getFirst(config.getTokenHeaderName());
        if (token != null) {
            String[] tokens = token.trim().split(" ");
            return tokens[tokens.length - 1];
        }
        return (String)request.getQueryParams().getFirst((Object)config.getTokenParamName());
    }
}

