/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.ribbon;

import cn.com.yusys.udp.cloud.gateway.context.UcgContext;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class UcgSwaggerRule
extends RoundRobinRule {
    public static final String TARGET_HEADER_KEY = "instance-prefer";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Server choose(Object key) {
        ILoadBalancer lb = this.getLoadBalancer();
        if (lb == null) {
            return null;
        }
        ServerWebExchange exchange = UcgContext.getExchange();
        ServerHttpRequest request = exchange.getRequest();
        String targetHost = request.getHeaders().getFirst(TARGET_HEADER_KEY);
        List allServers = lb.getAllServers();
        for (Server server : allServers) {
            if (!server.getHostPort().equalsIgnoreCase(targetHost)) continue;
            this.logger.trace("[udp-cloud-gateway]: [UcgSwaggerRule] {} -> {}", (Object)request.getPath(), (Object)server.getHostPort());
            return server;
        }
        return super.choose(key);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
    }
}

