/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.lb;

import cn.com.yusys.udp.cloud.gateway.context.UcgContext;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgLoadBalancerDepository;
import cn.com.yusys.udp.cloud.gateway.lb.GrayLoadBalancer;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.web.server.ServerWebExchange;

public class UcgLoadBalancerRule
extends AbstractLoadBalancerRule {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ZoneAvoidanceRule sysRule = new ZoneAvoidanceRule();
    private String clientName = "";

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Server choose(Object key) {
        AbstractLoadBalancerRule cacheRule;
        ZoneAvoidanceRule rule = this.sysRule;
        UcgLoadBalancerDepository depository = UcgLoadBalancerDepository.getInstance();
        if (depository != null && depository.isEnabled() && (cacheRule = this.getRule()) != null) {
            rule = cacheRule;
        }
        this.logger.trace("[udp-cloud-gateway]: [LoadBalancer] {} -> {} {}", new Object[]{this.clientName, rule.getClass().getSimpleName(), rule.hashCode()});
        rule.setLoadBalancer((ILoadBalancer)new GrayLoadBalancer(this.getLoadBalancer()));
        return rule.choose(key);
    }

    private AbstractLoadBalancerRule getRule() {
        UcgLoadBalancerDepository depository = UcgLoadBalancerDepository.getInstance();
        ServerWebExchange exchange = UcgContext.getExchange();
        if (exchange == null) {
            return depository.getRule(null, null, this.clientName);
        }
        Boolean useDefault = (Boolean)exchange.getAttribute(UcgUtils.DEFAULT_LOAD_BALANCER_ATTR);
        if (useDefault != null && useDefault.booleanValue()) {
            return depository.getRule(null, null, this.clientName);
        }
        String openApiId = (String)exchange.getAttribute(UcgUtils.REQUEST_OPEN_API_ID_ATTR);
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        String routeId = null;
        if (route != null) {
            routeId = route.getId();
        }
        return depository.getRule(openApiId, routeId, this.clientName);
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
        this.sysRule.initWithNiwsConfig(iClientConfig);
    }
}

