/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.lb;

import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class UcgLoadBalancerFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DefaultListableBeanFactory beanFactory;

    public UcgLoadBalancerFactory(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public AbstractLoadBalancerRule create(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            AbstractLoadBalancerRule result = (AbstractLoadBalancerRule)BeanUtils.instantiateClass(clazz);
            this.beanFactory.autowireBean((Object)result);
            return result;
        }
        catch (Exception e) {
            this.logger.error("[udp-cloud-gateway]: [LoadBalancer]", (Throwable)e);
            return null;
        }
    }
}

