/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgFlowInDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.gateway.common.param.GatewayParamParser;
import com.alibaba.csp.sentinel.adapter.gateway.common.param.RequestItemParser;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.adapter.gateway.sc.ServerWebExchangeItemParser;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.GatewayCallbackManager;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgSentinelFlowInFilter
implements UcgFilter {
    public static final int ORDER = -2147483348;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String module = "FLOW";
    protected final UcgFlowInDepository depository;
    private final GatewayParamParser<ServerWebExchange> paramParser = new GatewayParamParser((RequestItemParser)new ServerWebExchangeItemParser());

    public UcgSentinelFlowInFilter(UcgFlowInDepository depository) {
        this.depository = depository;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String[] resources;
        Mono mono = chain.filter(exchange);
        if (!this.depository.isEnabled()) {
            return mono;
        }
        this.logger.trace("[udp-cloud-gateway]: UcgSentinelFlowInFilter start");
        for (String resource : resources = UcgUtils.getResources(exchange, module)) {
            Set rulesForResource = GatewayRuleManager.getRulesForResource((String)resource);
            boolean hasResource = false;
            for (GatewayFlowRule flowRule : rulesForResource) {
                if (flowRule.getResourceMode() != 2) continue;
                hasResource = true;
                break;
            }
            if (!hasResource) continue;
            Object[] params = this.paramParser.parseParameterFor(resource, (Object)exchange, r -> r.getResourceMode() == 2);
            String origin = Optional.ofNullable(GatewayCallbackManager.getRequestOriginParser()).map(f -> (String)f.apply(exchange)).orElse("");
            this.logger.trace("[udp-cloud-gateway]: [FlowIn] {}{}{}", new Object[]{resource, Arrays.toString(params), origin});
            mono = mono.transform((Function)new SentinelReactorTransformer(new EntryConfig(resource, 3, EntryType.IN, 1, params, new ContextConfig(this.contextName(resource), origin))));
        }
        return mono;
    }

    private String contextName(String route) {
        return "sentinel_gateway_context$$route$$" + route;
    }

    public int getOrder() {
        return -2147483348;
    }
}

