/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.config.UcgRetryConfig;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.retry.Repeat;
import reactor.retry.RepeatContext;
import reactor.retry.Retry;
import reactor.retry.RetryContext;

public class UcgRetryFilter
implements GlobalFilter,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(UcgRetryFilter.class);
    public static final int ORDER = 10300;
    public static final String RETRY_ITERATION_KEY = "retry_iteration";
    protected final SpringClientFactory clientFactory;

    public UcgRetryFilter(SpringClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        UcgRetryConfig.Rule rule = (UcgRetryConfig.Rule)exchange.getAttribute(UcgUtils.RETRY_RULE);
        if (rule == null) {
            return chain.filter(exchange);
        }
        logger.trace("[udp-cloud-gateway]: UcgRetryFilter start");
        return this.retryFilter(rule).filter(exchange, chain);
    }

    public GatewayFilter retryFilter(UcgRetryConfig.Rule rule) {
        int retries = rule.getRetries();
        Predicate<RepeatContext> repeatPredicate = context -> {
            boolean statusRetry;
            ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
            if (this.exceedsMaxIterations(exchange, retries)) {
                return false;
            }
            HttpStatus statusCode = exchange.getResponse().getStatusCode();
            boolean bl = statusRetry = statusCode != null && rule.getStatuses().contains(statusCode);
            if (statusRetry) {
                this.handleRetry(exchange, rule);
            }
            return statusRetry;
        };
        Repeat statusCodeRepeat = Repeat.onlyIf(repeatPredicate).doOnRepeat(context -> this.reset((ServerWebExchange)context.applicationContext()));
        Predicate<RetryContext> retryPredicate = context -> {
            boolean retry;
            ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
            if (this.exceedsMaxIterations(exchange, retries)) {
                return false;
            }
            Throwable exception = context.exception();
            boolean bl = retry = exception != null && !(exception instanceof UcgException);
            if (retry) {
                this.handleRetry(exchange, rule);
            }
            return retry;
        };
        Retry exceptionRetry = Retry.onlyIf(retryPredicate).doOnRetry(context -> this.reset((ServerWebExchange)context.applicationContext())).retryMax((long)retries);
        return this.apply((Repeat<ServerWebExchange>)statusCodeRepeat, (Retry<ServerWebExchange>)exceptionRetry);
    }

    public void handleRetry(ServerWebExchange exchange, UcgRetryConfig.Rule rule) {
        Integer iteration = (Integer)exchange.getAttribute(RETRY_ITERATION_KEY);
        logger.trace("[udp-cloud-gateway]: [Retry] Iteration {} -> {}", (Object)rule.getResource(), (Object)iteration);
        if (rule.getRetryType() != UcgRetryConfig.RetryType.next) {
            return;
        }
        URI lbUrl = this.getLBUrl((LinkedHashSet)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR));
        if (lbUrl == null) {
            return;
        }
        String serviceId = lbUrl.getHost();
        ILoadBalancer loadBalancer = this.clientFactory.getLoadBalancer(serviceId);
        RibbonLoadBalancerContext context = this.clientFactory.getLoadBalancerContext(serviceId);
        List allServers = loadBalancer.getAllServers();
        if (allServers.size() == 0) {
            return;
        }
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        int current = 0;
        for (Server server : allServers) {
            ++current;
            if (!requestUrl.getHost().equals(server.getHost()) || requestUrl.getPort() != server.getPort()) continue;
            break;
        }
        int index = current % allServers.size();
        Server newServer = (Server)allServers.get(index);
        URI newRequestUrl = context.reconstructURIWithServer(newServer, requestUrl);
        logger.trace("[udp-cloud-gateway]: [Retry] Next {} -> {}", (Object)requestUrl, (Object)newRequestUrl);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, newRequestUrl);
    }

    public URI getLBUrl(LinkedHashSet<URI> uris) {
        if (uris == null) {
            return null;
        }
        for (URI uri : uris) {
            if (!uri.getScheme().equals("lb")) continue;
            return uri;
        }
        return null;
    }

    public boolean exceedsMaxIterations(ServerWebExchange exchange, long retries) {
        Integer iteration = (Integer)exchange.getAttribute(RETRY_ITERATION_KEY);
        return iteration != null && (long)iteration.intValue() >= retries;
    }

    public void reset(ServerWebExchange exchange) {
        Connection conn = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        if (conn != null) {
            exchange.getAttributes().remove(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        }
        ServerWebExchangeUtils.reset((ServerWebExchange)exchange);
    }

    public GatewayFilter apply(Repeat<ServerWebExchange> repeat, Retry<ServerWebExchange> retry) {
        return (exchange, chain) -> {
            Mono publisher = chain.filter(exchange).doOnSuccess(aVoid -> this.updateIteration(exchange)).doOnError(throwable -> this.updateIteration(exchange));
            if (retry != null) {
                publisher = publisher.retryWhen((Function)retry.withApplicationContext((Object)exchange));
            }
            if (repeat != null) {
                publisher = publisher.repeatWhen((Function)repeat.withApplicationContext((Object)exchange));
            }
            return Mono.fromDirect((Publisher)publisher);
        };
    }

    private void updateIteration(ServerWebExchange exchange) {
        int iteration = (Integer)exchange.getAttributeOrDefault(RETRY_ITERATION_KEY, (Object)-1);
        int newIteration = iteration + 1;
        exchange.getAttributes().put(RETRY_ITERATION_KEY, newIteration);
    }

    public int getOrder() {
        return 10300;
    }
}

