/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.commons.util.UcIpUtils;
import cn.com.yusys.udp.cloud.commons.util.UcWebFluxIpUtils;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgIpLimitDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgIpLimitFilter
implements UcgFilter {
    public static final int ORDER = -2147483548;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UcgIpLimitDepository depository;

    public UcgIpLimitFilter(UcgIpLimitDepository depository) {
        this.depository = depository;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgIPLimitFilter start");
        this.handle(exchange);
        return chain.filter(exchange);
    }

    public void handle(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String ip = UcWebFluxIpUtils.getIp((ServerHttpRequest)request, (boolean)this.depository.isWithProxy());
        if (ip == null) {
            throw new UcgException(HttpStatus.INTERNAL_SERVER_ERROR, "[udp-cloud-gateway]: [IPLimit] " + ip);
        }
        long longIp = UcIpUtils.ipToLong((String)ip);
        for (UcgIpLimitDepository.IpArea ipArea : this.depository.getBlackIpAreas()) {
            if (longIp < ipArea.getStart() || longIp > ipArea.getEnd()) continue;
            throw new UcgException(HttpStatus.FORBIDDEN, "[udp-cloud-gateway]: [IPLimit] " + ip + " \u5728\u9ed1\u540d\u5355");
        }
        if (this.depository.getWhiteIpAreas().size() > 0) {
            for (UcgIpLimitDepository.IpArea ipArea : this.depository.getWhiteIpAreas()) {
                if (longIp < ipArea.getStart() || longIp > ipArea.getEnd()) continue;
                return;
            }
            throw new UcgException(HttpStatus.FORBIDDEN, "[udp-cloud-gateway]: [IPLimit] " + ip + " \u4e0d\u5728\u767d\u540d\u5355");
        }
    }

    public int getOrder() {
        return -2147483548;
    }
}

