/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.depositories;

import cn.com.yusys.udp.cloud.gateway.config.UcgLoadBalancerConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import cn.com.yusys.udp.cloud.gateway.lb.UcgLoadBalancerFactory;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import java.util.LinkedHashMap;
import java.util.Map;

public class UcgLoadBalancerDepository
extends UcgDepository<UcgLoadBalancerConfig> {
    public static final String DEFAULT_RESOURCE = "LB:*";
    protected static UcgLoadBalancerDepository instance;
    protected final UcgLoadBalancerFactory loadBalancerFactory;
    protected Map<String, AbstractLoadBalancerRule> ruleMap = new LinkedHashMap<String, AbstractLoadBalancerRule>();
    protected Map<String, String> configMap = new LinkedHashMap<String, String>();

    public UcgLoadBalancerDepository(UcgLoadBalancerConfig config, UcgLoadBalancerFactory loadBalancerFactory) {
        super(config);
        this.loadBalancerFactory = loadBalancerFactory;
        instance = this;
    }

    public static UcgLoadBalancerDepository getInstance() {
        return instance;
    }

    @Override
    public synchronized void reload() {
        this.parseLoadBalancers();
    }

    private void parseLoadBalancers() {
        LinkedHashMap<String, AbstractLoadBalancerRule> newRuleMap = new LinkedHashMap<String, AbstractLoadBalancerRule>();
        LinkedHashMap<String, String> newConfigMap = new LinkedHashMap<String, String>();
        for (String ruleStr : ((UcgLoadBalancerConfig)this.ucgConfig).getRules()) {
            AbstractLoadBalancerRule oldRule;
            UcgLoadBalancerConfig.Rule rule = this.jsonParse(ruleStr, UcgLoadBalancerConfig.Rule.class);
            if (rule == null) {
                this.logger.error("[udp-cloud-gateway]: rule parse error: {}", (Object)ruleStr);
                continue;
            }
            newConfigMap.put(rule.getResource(), rule.getRuleClassName());
            String oldType = this.configMap.get(rule.getResource());
            if (oldType == null || !oldType.equals(rule.getRuleClassName()) || (oldRule = this.ruleMap.get(rule.getResource())) == null) continue;
            newRuleMap.put(rule.getResource(), oldRule);
        }
        if (this.configMap.get(DEFAULT_RESOURCE) != null && newConfigMap.get(DEFAULT_RESOURCE) != null && this.configMap.get(DEFAULT_RESOURCE).equals(newConfigMap.get(DEFAULT_RESOURCE))) {
            for (String key : this.ruleMap.keySet()) {
                AbstractLoadBalancerRule oldRule;
                if (!key.startsWith(DEFAULT_RESOURCE) || (oldRule = this.ruleMap.get(key)) == null) continue;
                newRuleMap.put(key, oldRule);
            }
        }
        this.configMap = newConfigMap;
        this.ruleMap = newRuleMap;
    }

    public AbstractLoadBalancerRule getRule(String apiId, String routeId, String serviceId) {
        String key;
        AbstractLoadBalancerRule rule;
        if (apiId != null && (rule = this.getRuleInstance(key = "LB:API:" + apiId, key)) != null) {
            return rule;
        }
        if (routeId != null && (rule = this.getRuleInstance(key = "LB:ROUTE:" + routeId, key)) != null) {
            return rule;
        }
        if (serviceId != null && this.configMap.get(DEFAULT_RESOURCE) != null) {
            return this.getRuleInstance(DEFAULT_RESOURCE, "LB:*:" + serviceId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractLoadBalancerRule getRuleInstance(String configKey, String cacheKey) {
        AbstractLoadBalancerRule rule = this.ruleMap.get(cacheKey);
        if (rule != null) {
            return rule;
        }
        String clazz = this.configMap.get(configKey);
        if (clazz == null) {
            return null;
        }
        UcgLoadBalancerDepository ucgLoadBalancerDepository = this;
        synchronized (ucgLoadBalancerDepository) {
            rule = this.loadBalancerFactory.create(this.configMap.get(configKey));
            if (rule != null) {
                this.ruleMap.put(cacheKey, rule);
            }
        }
        return rule;
    }

    public Map<String, String> getConfigs() {
        return this.configMap;
    }

    public Map<String, String> getRules() {
        LinkedHashMap<String, String> rt = new LinkedHashMap<String, String>();
        for (String key : this.ruleMap.keySet()) {
            String value = this.ruleMap.get(key).getClass().getName();
            rt.put(key, value);
        }
        return rt;
    }
}

