/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.depositories;

import cn.com.yusys.udp.cloud.commons.util.UcIpUtils;
import cn.com.yusys.udp.cloud.gateway.config.UcgIpLimitConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UcgIpLimitDepository
extends UcgDepository<UcgIpLimitConfig> {
    private static final int IP_MAX_LENGTH = 2;
    protected List<IpArea> blackIpAreaList = new ArrayList<IpArea>();
    protected List<IpArea> whiteIpAreaList = new ArrayList<IpArea>();

    public UcgIpLimitDepository(UcgIpLimitConfig config) {
        super(config);
    }

    @Override
    public synchronized void reload() {
        this.parseBlackIps();
        this.parseWhiteIps();
    }

    public boolean isWithProxy() {
        return ((UcgIpLimitConfig)this.ucgConfig).isWithProxy();
    }

    public List<IpArea> getBlackIpAreas() {
        return Collections.unmodifiableList(this.blackIpAreaList);
    }

    public List<IpArea> getWhiteIpAreas() {
        return Collections.unmodifiableList(this.whiteIpAreaList);
    }

    protected void parseBlackIps() {
        ArrayList<IpArea> blackIpAreaList = new ArrayList<IpArea>();
        for (String ips : ((UcgIpLimitConfig)this.ucgConfig).getBlackIps()) {
            this.parseIpArea(blackIpAreaList, ips);
        }
        this.blackIpAreaList = blackIpAreaList;
    }

    protected void parseWhiteIps() {
        ArrayList<IpArea> whiteIpAreaList = new ArrayList<IpArea>();
        for (String ips : ((UcgIpLimitConfig)this.ucgConfig).getWhiteIps()) {
            this.parseIpArea(whiteIpAreaList, ips);
        }
        this.whiteIpAreaList = whiteIpAreaList;
    }

    protected void parseIpArea(List<IpArea> list, String ips) {
        String startIp;
        if ("".equals(ips.trim())) {
            this.logger.error("IP\u8303\u56f4\u683c\u5f0f\u4e0d\u5408\u6cd5: {}", (Object)ips);
            return;
        }
        String[] split = ips.split("-");
        if (split.length > 2) {
            this.logger.error("IP\u8303\u56f4\u683c\u5f0f\u4e0d\u5408\u6cd5: {}", (Object)ips);
            return;
        }
        String endIp = startIp = split[0];
        if (split.length > 1) {
            endIp = split[1];
        }
        long start = UcIpUtils.ipToLong((String)startIp);
        long end = UcIpUtils.ipToLong((String)endIp);
        if (start < 0L || end < 0L) {
            this.logger.error("IP\u8303\u56f4\u683c\u5f0f\u4e0d\u5408\u6cd5: {}", (Object)ips);
            return;
        }
        list.add(new IpArea(startIp, endIp, start, end));
    }

    public static class IpArea {
        private String startIP;
        private String endIP;
        private long start;
        private long end;

        public IpArea() {
        }

        public IpArea(String startIP, String endIP, long start, long end) {
            this.startIP = startIP;
            this.endIP = endIP;
            this.start = start;
            this.end = end;
        }

        public String getStartIP() {
            return this.startIP;
        }

        public void setStartIP(String startIP) {
            this.startIP = startIP;
        }

        public String getEndIP() {
            return this.endIP;
        }

        public void setEndIP(String endIP) {
            this.endIP = endIP;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }
    }
}

