/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.controller;

import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.controller.vo.GenerateParam;
import cn.com.yusys.udp.cloud.gateway.controller.vo.JwtTokenInfoVO;
import cn.com.yusys.udp.cloud.gateway.controller.vo.RefreshParam;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgOpenApiDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.util.UcgJwtUtils;
import com.auth0.jwt.interfaces.Claim;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import reactor.core.publisher.Mono;

@ResponseBody
@RequestMapping(value={"/api/auth/token"})
public class UcgJwtTokenController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UcgOpenApiDepository openApiCache;

    @PostMapping(value={"/generate"})
    public Mono<JwtTokenInfoVO> generate(@RequestBody GenerateParam param) {
        if (!this.openApiCache.isEnabled()) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_ACCEPTABLE, "OpenAPI\u5df2\u7981\u7528")));
        }
        String clientId = param.getClientId();
        String clientSecret = param.getClientSecret();
        Map<String, UcgOpenApiConfig.Client> clients = this.openApiCache.getClients();
        UcgOpenApiConfig.Client client = clients.get(clientId);
        JwtTokenInfoVO rt = new JwtTokenInfoVO();
        if (client == null) {
            return Mono.just((Object)new JwtTokenInfoVO(-1, "\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728"));
        }
        if (!"jwt".equalsIgnoreCase(client.getAuthType())) {
            return Mono.just((Object)new JwtTokenInfoVO(-2, "\u5f53\u524d\u5ba2\u6237\u7aef\u4e0d\u652f\u6301JWT\u9a8c\u8bc1"));
        }
        if (!clientSecret.equals(client.getClientSecret())) {
            return Mono.just((Object)new JwtTokenInfoVO(-3, "\u5bc6\u7801\u9519\u8bef"));
        }
        return Mono.just((Object)this.createTokenRt(clientId, clientSecret));
    }

    @PostMapping(value={"/refresh"})
    public Mono<JwtTokenInfoVO> refresh(@RequestBody RefreshParam param) {
        if (!this.openApiCache.isEnabled()) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_ACCEPTABLE, "OpenAPI\u5df2\u7981\u7528")));
        }
        String token = param.getToken();
        Claim claim = UcgJwtUtils.getClaim(token, "client_id");
        if (claim == null) {
            return Mono.just((Object)new JwtTokenInfoVO(-1, "token\u683c\u5f0f\u4e0d\u5408\u6cd5"));
        }
        String clientId = claim.asString();
        if (clientId == null || "".equals(clientId)) {
            return Mono.just((Object)new JwtTokenInfoVO(-1, "token\u683c\u5f0f\u4e0d\u5408\u6cd5"));
        }
        UcgOpenApiConfig.Client client = this.openApiCache.getClients().get(clientId);
        if (client == null) {
            return Mono.just((Object)new JwtTokenInfoVO(-2, "\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728"));
        }
        if (!"jwt".equalsIgnoreCase(client.getAuthType())) {
            return Mono.just((Object)new JwtTokenInfoVO(-3, "\u5f53\u524d\u5ba2\u6237\u7aef\u4e0d\u652f\u6301JWT\u9a8c\u8bc1"));
        }
        if (!UcgJwtUtils.verifyToken(client.getClientSecret(), token)) {
            return Mono.just((Object)new JwtTokenInfoVO(-4, "token\u6821\u9a8c\u5931\u8d25"));
        }
        return Mono.just((Object)this.createTokenRt(clientId, client.getClientSecret()));
    }

    private JwtTokenInfoVO createTokenRt(String clientId, String clientSecret) {
        JwtTokenInfoVO rt = new JwtTokenInfoVO();
        long start = System.currentTimeMillis();
        long timeout = this.openApiCache.getJwtTimeout();
        long exp = (start + timeout) / 1000L * 1000L;
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("client_id", clientId);
        String newToken = UcgJwtUtils.createToken(clientSecret, exp, header);
        rt.setToken(newToken);
        rt.setTimeout(timeout);
        rt.setExp(exp);
        return rt;
    }
}

