/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.UcgAutoConfiguration;
import cn.com.yusys.udp.cloud.gateway.config.UcgUaaAuthConfig;
import cn.com.yusys.udp.cloud.gateway.filter.UcgUaaAuthFilter;
import cn.com.yusys.udp.cloud.gateway.uaa.UcgUaaAuthChecker;
import cn.com.yusys.udp.cloud.gateway.uaa.UcgUaaAuthRedisChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;

@AutoConfigureAfter(value={UcgAutoConfiguration.class})
@ConditionalOnProperty(name={"udp.cloud.gateway.uaa-auth-enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={UcgUaaAuthConfig.class})
public class UcgUaaAuthAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public UcgUaaAuthFilter UcgUaaAuthFilter(UcgUaaAuthConfig config, @Autowired(required=false) UcgUaaAuthChecker ucgUaaAuthChecker) {
        this.logger.info("[udp-cloud-gateway]: register UcgUaaAuthFilter");
        return new UcgUaaAuthFilter(config, ucgUaaAuthChecker);
    }

    @ConditionalOnClass(value={RedisTemplate.class})
    @ConditionalOnBean(value={RedisTemplate.class})
    @ConditionalOnProperty(name={"udp.cloud.gateway.uaa-auth-enabled"}, matchIfMissing=false)
    static class CheckerConfiguration {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        CheckerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public UcgUaaAuthChecker ucgUaaAuthChecker(RedisTemplate<String, String> redisTemplate) {
            this.logger.info("[udp-cloud-gateway]: register UcgUaaAuthRedisChecker");
            return new UcgUaaAuthRedisChecker(redisTemplate);
        }
    }
}

