/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.UcgAutoConfiguration;
import cn.com.yusys.udp.cloud.gateway.config.UcgRetryConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRetryDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgRetryFilter;
import cn.com.yusys.udp.cloud.gateway.filter.UcgRetryPreFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={UcgAutoConfiguration.class})
@ConditionalOnBean(value={SpringClientFactory.class})
@ConditionalOnProperty(name={"udp.cloud.gateway.retry-enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcgRetryConfig.class})
public class UcgRetryAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public UcgRetryDepository ucgRetryDepository(UcgRetryConfig properties) {
        return new UcgRetryDepository(properties);
    }

    @Bean
    public UcgRetryPreFilter ucgRetryPreFilter(UcgRetryDepository depository) {
        this.logger.info("[udp-cloud-gateway]: register UcgRetryPreFilter");
        return new UcgRetryPreFilter(depository);
    }

    @Bean
    public UcgRetryFilter ucgRetryFilter(SpringClientFactory clientFactory) {
        this.logger.info("[udp-cloud-gateway]: register UcgRetryFilter");
        return new UcgRetryFilter(clientFactory);
    }
}

