/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.configuration;

import cn.com.yusys.udp.cloud.gateway.config.UcgLoadBalancerConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgLoadBalancerDepository;
import cn.com.yusys.udp.cloud.gateway.lb.UcgLoadBalancerFactory;
import cn.com.yusys.udp.cloud.gateway.lb.UcgRibbonClientConfiguration;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.RibbonClients;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureBefore(value={RibbonAutoConfiguration.class})
@ConditionalOnClass(value={AbstractLoadBalancerRule.class})
@ConditionalOnProperty(name={"udp.cloud.gateway.load-balancer-enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UcgLoadBalancerConfig.class})
public class UcgLoadBalancerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public UcgLoadBalancerFactory ucgLoadBalancerFactory(DefaultListableBeanFactory beanFactory) {
        return new UcgLoadBalancerFactory(beanFactory);
    }

    @Bean
    public UcgLoadBalancerDepository UcgLoadBalancerDepository(UcgLoadBalancerConfig properties, UcgLoadBalancerFactory ucgLoadBalancerFactory) {
        return new UcgLoadBalancerDepository(properties, ucgLoadBalancerFactory);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={SpringClientFactory.class})
    @ConditionalOnProperty(name={"udp.cloud.gateway.load-balancer-enabled"}, matchIfMissing=true)
    @AutoConfigureAfter(value={RibbonAutoConfiguration.class})
    @RibbonClients(defaultConfiguration={UcgRibbonClientConfiguration.class})
    public static class UcgRibbonAutoConfiguration {
    }
}

