/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.actuate;

import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDegradeInDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgFlowInDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgInstanceDownDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgIpLimitDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgLoadBalancerDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgOpenApiDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRetryDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import reactor.core.publisher.Mono;

@RestControllerEndpoint(id="ucg")
public class UcgControllerEndpoint {
    @Autowired
    private ApplicationContext applicationContext;

    @GetMapping(value={"/"})
    public Mono<Map<String, Object>> enabled() {
        UcgInstanceDownDepository instanceDownDepository = this.getBean(UcgInstanceDownDepository.class);
        UcgIpLimitDepository ipLimitDepository = this.getBean(UcgIpLimitDepository.class);
        UcgOpenApiDepository openApiDepository = this.getBean(UcgOpenApiDepository.class);
        UcgFlowInDepository flowInDepository = this.getBean(UcgFlowInDepository.class);
        UcgDegradeInDepository degradeInDepository = this.getBean(UcgDegradeInDepository.class);
        UcgLoadBalancerDepository loadBalancerDepository = this.getBean(UcgLoadBalancerDepository.class);
        UcgRetryDepository retryDepository = this.getBean(UcgRetryDepository.class);
        LinkedHashMap<String, Object> rt = new LinkedHashMap<String, Object>();
        this.addEnabled(rt, "instanceDown", instanceDownDepository);
        this.addEnabled(rt, "ipLimit", ipLimitDepository);
        this.addEnabled(rt, "openApi", openApiDepository);
        this.addEnabled(rt, "flowIn", flowInDepository);
        this.addEnabled(rt, "degradeIn", degradeInDepository);
        this.addEnabled(rt, "loadBalancer", loadBalancerDepository);
        this.addEnabled(rt, "retry", retryDepository);
        return Mono.just(rt);
    }

    public void addEnabled(Map<String, Object> rt, String key, UcgDepository<?> depository) {
        if (depository != null && depository.isEnabled()) {
            rt.put(key, true);
        } else {
            rt.put(key, false);
        }
    }

    @GetMapping(value={"/instanceDown"})
    public Mono<Map<String, Object>> instanceDown() {
        LinkedHashMap<String, Object> rt;
        UcgInstanceDownDepository instanceDownDepository = this.getBean(UcgInstanceDownDepository.class);
        if (this.addCommon(instanceDownDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("instanceId", instanceDownDepository.getInstanceId());
        rt.put("isDown", instanceDownDepository.isDown());
        rt.put("ids", instanceDownDepository.getIds());
        return Mono.just(rt);
    }

    @GetMapping(value={"/ipLimit"})
    public Mono<Map<String, Object>> ipLimit() {
        LinkedHashMap<String, Object> rt;
        UcgIpLimitDepository ipLimitDepository = this.getBean(UcgIpLimitDepository.class);
        if (this.addCommon(ipLimitDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("blackIps", ipLimitDepository.getBlackIpAreas());
        rt.put("whiteIps", ipLimitDepository.getWhiteIpAreas());
        return Mono.just(rt);
    }

    @GetMapping(value={"/openApi"})
    public Mono<Map<String, Object>> openApi() {
        LinkedHashMap<String, Object> rt;
        UcgOpenApiDepository openApiDepository = this.getBean(UcgOpenApiDepository.class);
        if (this.addCommon(openApiDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("ignorePaths", openApiDepository.getIgnorePaths());
        rt.put("clientIdName", openApiDepository.getClientIdName());
        rt.put("clientSecretName", openApiDepository.getClientSecretName());
        rt.put("keepClientSecret", openApiDepository.isKeepClientSecret());
        rt.put("httpAuthUrl", openApiDepository.getHttpAuthUrl());
        rt.put("paths", openApiDepository.getPaths());
        rt.put("antPaths", openApiDepository.getAntPaths());
        HashMap<String, UcgOpenApiConfig.Client> users = new HashMap<String, UcgOpenApiConfig.Client>(16);
        Map<String, UcgOpenApiConfig.Client> cachedUserMap = openApiDepository.getClients();
        for (String userName : cachedUserMap.keySet()) {
            UcgOpenApiConfig.Client cachedClient = cachedUserMap.get(userName);
            UcgOpenApiConfig.Client client = new UcgOpenApiConfig.Client();
            client.setPathIds(cachedClient.getPathIds());
            client.setAuthType(cachedClient.getAuthType());
            client.setClientId(cachedClient.getClientId());
            client.setClientSecret("***");
            users.put(userName, client);
        }
        rt.put("users", users);
        return Mono.just(rt);
    }

    @GetMapping(value={"/flowIn"})
    public Mono<Map<String, Object>> flowIn() {
        LinkedHashMap<String, Object> rt;
        UcgFlowInDepository flowInDepository = this.getBean(UcgFlowInDepository.class);
        if (this.addCommon(flowInDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("rules", flowInDepository.getRules());
        rt.put("gatewayFlowRules", GatewayRuleManager.getRules());
        rt.put("apiGroups", flowInDepository.getApiGroups());
        rt.put("apiDefinitions", GatewayApiDefinitionManager.getApiDefinitions());
        return Mono.just(rt);
    }

    @GetMapping(value={"/degradeIn"})
    public Mono<Map<String, Object>> degradeIn() {
        LinkedHashMap<String, Object> rt;
        UcgDegradeInDepository degradeInDepository = this.getBean(UcgDegradeInDepository.class);
        if (this.addCommon(degradeInDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("rules", degradeInDepository.getRules());
        rt.put("degradeRules", DegradeRuleManager.getRules());
        return Mono.just(rt);
    }

    @GetMapping(value={"/loadBalancer"})
    public Mono<Map<String, Object>> loadBalancer() {
        LinkedHashMap<String, Object> rt;
        UcgLoadBalancerDepository loadBalancerDepository = this.getBean(UcgLoadBalancerDepository.class);
        if (this.addCommon(loadBalancerDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("configs", loadBalancerDepository.getConfigs());
        rt.put("rules", loadBalancerDepository.getRules());
        return Mono.just(rt);
    }

    @GetMapping(value={"/retry"})
    public Mono<Map<String, Object>> retry() {
        LinkedHashMap<String, Object> rt;
        UcgRetryDepository retryDepository = this.getBean(UcgRetryDepository.class);
        if (this.addCommon(retryDepository, rt = new LinkedHashMap<String, Object>())) {
            return Mono.error((Throwable)((Object)new UcgException(HttpStatus.NOT_FOUND)));
        }
        rt.put("rules", retryDepository.getRules());
        return Mono.just(rt);
    }

    private boolean addCommon(UcgDepository<?> depository, Map<String, Object> rt) {
        if (depository == null) {
            return true;
        }
        rt.put("enabled", depository.isEnabled());
        return false;
    }

    private String formatTime(Long time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(new Date(time));
    }

    private <T> T getBean(Class<T> clazz) {
        try {
            return (T)this.applicationContext.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }
}

