/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway;

import cn.com.yusys.udp.cloud.gateway.config.UcgResponse;
import cn.com.yusys.udp.cloud.gateway.context.UcgContext;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDegradeInDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgFlowInDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import java.net.ConnectException;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgErrorWebExceptionHandler
implements ErrorWebExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<UcgFilter> ucgFilters;
    @Autowired(required=false)
    private UcgFlowInDepository flowInDepository;
    @Autowired(required=false)
    private UcgDegradeInDepository degradeInDepository;

    public UcgErrorWebExceptionHandler(List<UcgFilter> ucgFilters) {
        this.ucgFilters = ucgFilters;
    }

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        ServerHttpResponse response = exchange.getResponse();
        if (response.isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        response.getHeaders().set("Content-Type", "text/html;charset=utf-8");
        String resBody = null;
        if (ex instanceof ResponseStatusException) {
            ResponseStatusException rex = (ResponseStatusException)ex;
            response.setStatusCode(rex.getStatus());
            if (((ResponseStatusException)ex).getStatus().value() >= 500) {
                this.logger.error(UcgUtils.buildRequestLog(false, exchange, rex.getReason()));
            } else {
                this.logger.warn(UcgUtils.buildRequestLog(false, exchange, rex.getReason()));
            }
        } else if (ex instanceof ConnectException) {
            response.setStatusCode(HttpStatus.BAD_GATEWAY);
            this.logger.error(UcgUtils.buildRequestLog(false, exchange, ex.toString()));
        } else if (ex instanceof BlockException) {
            response.setStatusCode(HttpStatus.FORBIDDEN);
            BlockException bex = (BlockException)ex;
            resBody = this.handleBlockException(response, bex);
            this.logger.error(UcgUtils.buildRequestLog(false, exchange, bex.getRule().getResource() + "=" + ex.getClass().getSimpleName()));
        } else {
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            this.logger.error(UcgUtils.buildRequestLog(false, exchange, ex.toString()));
            this.logger.error("", ex);
        }
        UcgContext.clear();
        if (this.ucgFilters != null) {
            for (UcgFilter ucgFilter : this.ucgFilters) {
                try {
                    ucgFilter.errorFilter(exchange);
                }
                catch (Exception e) {
                    this.logger.error("errorFilter", (Throwable)e);
                }
            }
        }
        if (resBody == null) {
            resBody = response.getStatusCode() == null ? "null" : response.getStatusCode().value() + " " + response.getStatusCode().getReasonPhrase();
        }
        String finalResBody = resBody;
        return response.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory bufferFactory = response.bufferFactory();
            return bufferFactory.wrap(finalResBody.getBytes());
        }));
    }

    protected String handleBlockException(ServerHttpResponse response, BlockException bex) {
        String resource = bex.getRule().getResource();
        UcgResponse res = null;
        if (bex instanceof ParamFlowException) {
            if (this.flowInDepository != null) {
                res = this.flowInDepository.getResponse(resource);
            }
        } else if (bex instanceof DegradeException && this.degradeInDepository != null) {
            res = this.degradeInDepository.getResponse(resource);
        }
        if (res == null) {
            return null;
        }
        if (res.getStatus() != null) {
            response.setStatusCode(res.getStatus());
        }
        if (res.getContentType() != null) {
            response.getHeaders().set("Content-Type", res.getContentType());
        }
        return res.getBody();
    }
}

