/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.discovery.nacos.loadbalancer.rule;

import cn.com.yusys.udp.cloud.lb.rule.IRule;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.balancer.NacosBalancer;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;

public class UcNacosRule
extends IRule {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;

    public UcNacosRule(String serviceId) {
        super(serviceId);
    }

    public Response<ServiceInstance> getInstanceResponse(Request request, List<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            this.logger.warn("No servers available for service: " + this.serviceId);
            return new EmptyResponse();
        }
        try {
            String clusterName = this.nacosDiscoveryProperties.getClusterName();
            List<Object> instancesToChoose = serviceInstances;
            if (StringUtils.isNotBlank((CharSequence)clusterName)) {
                List sameClusterInstances = serviceInstances.stream().filter(serviceInstance -> {
                    String cluster = (String)serviceInstance.getMetadata().get("nacos.cluster");
                    return StringUtils.equals((CharSequence)cluster, (CharSequence)clusterName);
                }).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sameClusterInstances)) {
                    instancesToChoose = sameClusterInstances;
                }
            } else {
                this.logger.warn("A cross-cluster call occurs\uff0cname = {}, clusterName = {}, instance = {}", new Object[]{this.serviceId, clusterName, serviceInstances});
            }
            ServiceInstance instance = NacosBalancer.getHostByRandomWeight3(instancesToChoose);
            return new DefaultResponse(instance);
        }
        catch (Exception e) {
            this.logger.warn("NacosLoadBalancer error", (Throwable)e);
            return null;
        }
    }
}

