/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.discovery.nacos.ribbon;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.ribbon.ExtendBalancer;
import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class UcNacosRule
extends AbstractLoadBalancerRule {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    @Autowired
    private NacosServiceManager nacosServiceManager;

    public Server choose(Object key) {
        try {
            String clusterName = this.nacosDiscoveryProperties.getClusterName();
            String group = this.nacosDiscoveryProperties.getGroup();
            BaseLoadBalancer loadBalancer = (BaseLoadBalancer)this.getLoadBalancer();
            String name = loadBalancer.getName();
            NamingService namingService = this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
            List instances = namingService.selectInstances(name, group, true);
            List lbInstances = instances.stream().filter(instance -> {
                List allServers = loadBalancer.getAllServers();
                for (Server server : allServers) {
                    if (!server.getId().equals(instance.getIp() + ":" + instance.getPort())) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(lbInstances)) {
                this.logger.warn("no instance in service {}", (Object)name);
                return null;
            }
            List instancesToChoose = lbInstances;
            if (StringUtils.isNotBlank((CharSequence)clusterName)) {
                List sameClusterInstances = lbInstances.stream().filter(instance -> Objects.equals(clusterName, instance.getClusterName())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sameClusterInstances)) {
                    instancesToChoose = sameClusterInstances;
                } else {
                    this.logger.warn("A cross-cluster call occurs\uff0cname = {}, clusterName = {}, instance = {}", new Object[]{name, clusterName, instances});
                }
            }
            Instance instance2 = ExtendBalancer.getHostByRandomWeight2(instancesToChoose);
            return new NacosServer(instance2);
        }
        catch (Exception e) {
            this.logger.warn("NacosRule error", (Throwable)e);
            return null;
        }
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }
}

