/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.config.nacos;

import cn.com.yusys.udp.cloud.commons.config.listener.UcConfigListener;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;

public class UcConfigNacosHandler {
    private final NacosConfigProperties properties;
    private ConfigService configService;

    public UcConfigNacosHandler(NacosConfigManager nacosConfigManager, NacosConfigProperties properties) {
        this.properties = properties;
        if (nacosConfigManager != null) {
            this.configService = nacosConfigManager.getConfigService();
        }
    }

    public String getConfig(String dataId, String group) throws NacosException {
        if (group == null) {
            group = this.properties.getGroup();
        }
        return this.configService.getConfig(dataId, group, (long)this.properties.getTimeout());
    }

    public void addListener(String dataId, String group, final UcConfigListener cl) throws NacosException {
        if (group == null) {
            group = this.properties.getGroup();
        }
        AbstractSharedListener listener = new AbstractSharedListener(){

            public void innerReceive(String dataId, String group, String configInfo) {
                cl.onRefresh(configInfo);
            }
        };
        listener.fillContext(dataId, group);
        this.configService.addListener(dataId, group, (Listener)listener);
    }
}

