/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.config.nacos;

import cn.com.yusys.udp.cloud.commons.config.listener.UcConfigListener;
import cn.com.yusys.udp.cloud.config.nacos.UcConfigNacosHandler;
import cn.com.yusys.udp.cloud.config.nacos.UcConfigNacosProperties;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={UcConfigNacosProperties.class})
@ConditionalOnBean(value={NacosConfigManager.class})
@ConditionalOnProperty(name={"udp.cloud.config.nacos.enabled"}, matchIfMissing=true)
public class UcConfigNacosAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private NacosConfigManager nacosConfigManager;
    @Autowired
    private NacosConfigProperties nacosConfigProperties;
    @Autowired(required=false)
    private List<UcConfigListener> ucConfigListeners;
    @Autowired
    private UcConfigNacosProperties ucConfigNacosProperties;

    @PostConstruct
    public void ucConfigSourceNacosInit() {
        UcConfigNacosHandler nacosConfigHandler = new UcConfigNacosHandler(this.nacosConfigManager, this.nacosConfigProperties);
        try {
            if (this.ucConfigListeners != null) {
                String group = this.ucConfigNacosProperties.getGroup();
                if (group == null || "".equals(group.trim())) {
                    group = null;
                }
                for (UcConfigListener ls : this.ucConfigListeners) {
                    String config = nacosConfigHandler.getConfig(ls.getDataId(), group);
                    ls.onLoad(config);
                    nacosConfigHandler.addListener(ls.getDataId(), group, ls);
                }
            }
            this.logger.info("[udp-cloud-config]: nacos configSource load finished");
        }
        catch (NacosException e) {
            this.logger.error("[udp-cloud-config]: nacos configSource load error", (Throwable)e);
        }
    }
}

