/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.commons.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.util.List;
import java.util.TimeZone;
import org.springframework.util.StringUtils;

public class JsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> valueTypeRef) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, valueTypeRef);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz, String fieldName) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            JsonNode node = JsonUtil.toJsonNode(json);
            if (node == null) {
                return null;
            }
            if (fieldName.indexOf(".") != -1) {
                String[] fields;
                for (String field : fields = fieldName.split("\\.")) {
                    node = node.get(field);
                }
                if (node == null) {
                    return null;
                }
                return (T)objectMapper.readValue(node.toString(), clazz);
            }
            return (T)objectMapper.readValue(node.get(fieldName).toString(), clazz);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static JsonNode toJsonNode(String json) {
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        try {
            return objectMapper.readTree(json);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> List<T> toList(InputStream io, Class<T> clazz) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
            return (List)objectMapper.readValue(io, javaType);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> List<T> toList(byte[] bytes, Class<T> clazz) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
            return (List)objectMapper.readValue(bytes, javaType);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T toObject(InputStream io, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(io, clazz);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T toObject(byte[] bytes, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(bytes, clazz);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setTimeZone(TimeZone.getDefault());
    }
}

