/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.commons.util;

import org.springframework.http.HttpHeaders;

public class UcIpUtils {
    public static final String[] IP_PROXY_HEADERS = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    private static final int IP_LENGTH = 4;
    private static final int BYTE_MAX = 255;

    public static long ipToLong(String ip) {
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            return -1L;
        }
        long ip1 = Long.parseLong(ips[0]);
        if (ip1 < 0L || ip1 > 255L) {
            return -1L;
        }
        long ip2 = Long.parseLong(ips[1]);
        if (ip2 < 0L || ip2 > 255L) {
            return -1L;
        }
        long ip3 = Long.parseLong(ips[2]);
        if (ip3 < 0L || ip3 > 255L) {
            return -1L;
        }
        long ip4 = Long.parseLong(ips[3]);
        if (ip4 < 0L || ip4 > 255L) {
            return -1L;
        }
        return ip1 << 24 | ip2 << 16 | ip3 << 8 | ip4;
    }

    public static String longToIp(long ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip >> 24);
        sb.append(".");
        sb.append((ip & 0xFFFFFFL) >> 16);
        sb.append(".");
        sb.append((ip & 0xFFFFL) >> 8);
        sb.append(".");
        sb.append(ip & 0xFFL);
        return sb.toString();
    }

    public static String getIps(HttpHeaders headers, String remoteAddress, boolean withProxy) {
        if (!withProxy) {
            return remoteAddress;
        }
        for (String key : IP_PROXY_HEADERS) {
            String ip = headers.getFirst(key);
            if (ip == null || ip.length() <= 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return remoteAddress;
    }

    public static String pickIp(String ips) {
        if (ips == null) {
            return null;
        }
        String[] arr = ips.split(",");
        String ip = null;
        for (String str : arr) {
            if ("unknown".equalsIgnoreCase(str)) continue;
            ip = "0.0.0.0.0.0.0.1".equals(str) || "0.0.0.0.0.0.0.1%0".equals(str) || "0:0:0:0:0:0:0:1".equals(str) ? "127.0.0.1" : str.trim();
        }
        return ip;
    }
}

