/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.commons.license;

import cn.com.yusys.license.LicenseException;
import cn.com.yusys.license.LicenseManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class UcLicenseApplicationListener
implements ApplicationListener<ApplicationContextInitializedEvent>,
Ordered {
    private static final String PRODUCT_CODE = "0000001122";
    private static final String EXPEND_INFO = "YUDP";
    private static final String BOOTSTRAP_ENABLED_PROPERTY = "spring.cloud.bootstrap.enabled";
    private static final String MARKER_CLASS = "org.springframework.cloud.bootstrap.marker.Marker";
    private static final boolean MARKER_CLASS_EXISTS = UcLicenseApplicationListener.markerClassExists();
    private static final String CLASSPATH_SCHEME = "classpath:";
    private static final String FILE_SCHEME = "file:";
    public static final String LICENSE_KEY_MODEL = "license.license-model";
    public static final String LICENSE_KEY_CONTEXT = "license.license-context";
    public static final String LICENSE_KEY_FILE = "license.license-file";
    public static final String LICENSE_KEY_MAC_FILE = "license.license-mac-file";
    private static final String SOURCE_NAME = "udp-cloud-license.properties";
    public static final String BOOT_LICENSE_KEY_MODEL = "license.licenseModel";
    public static final String BOOT_LICENSE_KEY_CONTEXT = "license.licenseContext";
    public static final String BOOT_LICENSE_KEY_FILE = "license.licenseFile";
    public static final String BOOT_LICENSE_KEY_MAC_FILE = "license.licenseMacFile";
    private static final AtomicBoolean checked = new AtomicBoolean(false);
    private final DefaultResourceLoader resourceLoader = new DefaultResourceLoader();

    public void onApplicationEvent(ApplicationContextInitializedEvent event) {
        if (checked.get()) {
            return;
        }
        ConfigurableApplicationContext context = event.getApplicationContext();
        this.locate(context);
        if (this.bootstrapEnabled((Environment)context.getEnvironment())) {
            if (context.getParent() != null) {
                this.checkLicense(context);
                checked.set(true);
            }
        } else {
            this.checkLicense(context);
        }
    }

    private void locate(ConfigurableApplicationContext context) {
        ConfigurableEnvironment env = context.getEnvironment();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (env.getProperty(LICENSE_KEY_MODEL) != null) {
            map.put(BOOT_LICENSE_KEY_MODEL, env.getProperty(LICENSE_KEY_MODEL));
        }
        if (env.getProperty(LICENSE_KEY_CONTEXT) != null) {
            map.put(BOOT_LICENSE_KEY_CONTEXT, env.getProperty(LICENSE_KEY_CONTEXT));
        }
        if (env.getProperty(LICENSE_KEY_FILE) != null) {
            map.put(BOOT_LICENSE_KEY_FILE, env.getProperty(LICENSE_KEY_FILE));
        }
        if (env.getProperty(LICENSE_KEY_MAC_FILE) != null) {
            map.put(BOOT_LICENSE_KEY_MAC_FILE, env.getProperty(LICENSE_KEY_MAC_FILE));
        }
        if (map.size() == 0) {
            return;
        }
        env.getPropertySources().addLast((PropertySource)new MapPropertySource(SOURCE_NAME, map));
    }

    private void checkLicense(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        String licenseModel = environment.getProperty(BOOT_LICENSE_KEY_MODEL);
        String licenseContext = environment.getProperty(BOOT_LICENSE_KEY_CONTEXT);
        String licenseFile = environment.getProperty(BOOT_LICENSE_KEY_FILE);
        String licenseMacFile = environment.getProperty(BOOT_LICENSE_KEY_MAC_FILE);
        if (licenseModel == null) {
            licenseModel = "PRO";
        }
        InputStream licenseInputStream = null;
        if (!StringUtils.isEmpty((Object)licenseContext)) {
            licenseInputStream = new ByteArrayInputStream(licenseContext.getBytes());
        } else if (!StringUtils.isEmpty((Object)licenseFile)) {
            licenseInputStream = this.getFileInputStream(licenseFile);
        }
        if (licenseInputStream == null) {
            System.err.println("udp-cloud license check failure: license not found");
            this.exit(context);
        }
        LicenseManager lManager = LicenseManager.getInstance();
        lManager.setLicenseModel(licenseModel);
        lManager.setInputStream(licenseInputStream);
        if (licenseMacFile != null) {
            lManager.setMacFile(licenseMacFile);
        }
        try {
            String info = lManager.initialize(PRODUCT_CODE, EXPEND_INFO);
            System.out.println("udp-cloud license check success:\n" + info.trim());
            return;
        }
        catch (LicenseException e) {
            System.err.println("udp-cloud license check failure: " + e.getMessage().trim());
        }
        catch (Exception e) {
            System.err.println("udp-cloud license check failure: " + e);
        }
        this.exit(context);
    }

    private InputStream getFileInputStream(String path) {
        try {
            if (path.startsWith(CLASSPATH_SCHEME) || path.startsWith(FILE_SCHEME)) {
                Resource resource = this.resourceLoader.getResource(path);
                if (resource.exists()) {
                    System.out.println("udp-cloud license file: " + resource.getURL());
                    return resource.getInputStream();
                }
                System.err.println("udp-cloud license file not found: " + path);
                return null;
            }
            Resource fileResource = this.resourceLoader.getResource(FILE_SCHEME + path);
            if (fileResource.exists()) {
                System.out.println("udp-cloud license file: " + fileResource.getURL());
                return fileResource.getInputStream();
            }
            Resource classPathResource = this.resourceLoader.getResource(CLASSPATH_SCHEME + path);
            if (classPathResource.exists()) {
                System.out.println("udp-cloud license file: " + classPathResource.getURL());
                return classPathResource.getInputStream();
            }
            System.err.println("udp-cloud license file not found: file:" + path + ",classpath:" + path);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void exit(ConfigurableApplicationContext context) {
        context.close();
        System.exit(1);
    }

    private boolean bootstrapEnabled(Environment environment) {
        return (Boolean)environment.getProperty(BOOTSTRAP_ENABLED_PROPERTY, Boolean.class, (Object)false) != false || MARKER_CLASS_EXISTS;
    }

    private static boolean markerClassExists() {
        try {
            ClassUtils.forName((String)MARKER_CLASS, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public int getOrder() {
        return 2147482647;
    }
}

