/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.commons.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class UcCryptoUtils {
    public static String toHexString(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        if (data == null || data.length <= 0) {
            return null;
        }
        for (byte b : data) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] md5(String str) {
        return UcCryptoUtils.md5SaltInter(str, null, 1);
    }

    public static byte[] md5Inter(String str, int hashIterations) {
        return UcCryptoUtils.md5SaltInter(str, null, hashIterations);
    }

    public static byte[] md5SaltInter(String str, String salt, int hashIterations) {
        byte[] rtValue;
        try {
            str = str == null ? "" : str;
            salt = salt == null ? "" : salt;
            byte[] bytes = str.getBytes();
            byte[] saltBytes = salt.getBytes();
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (salt != null) {
                digest.reset();
                digest.update(saltBytes);
            }
            rtValue = digest.digest(bytes);
            int iterations = hashIterations - 1;
            for (int i = 0; i < iterations; ++i) {
                digest.reset();
                rtValue = digest.digest(rtValue);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return rtValue;
    }
}

