/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.apilimit.interceptor;

import cn.com.yusys.udp.cloud.apilimit.UcApiLimitProperties;
import cn.com.yusys.udp.cloud.apilimit.exception.UcApiLimitException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

public class UcApiLimitHandlerInterceptor
implements HandlerInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UcApiLimitProperties properties;

    public UcApiLimitHandlerInterceptor(UcApiLimitProperties properties) {
        this.properties = properties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Object bestMatchingObject;
        if (!this.properties.isEnabled()) {
            return true;
        }
        String requestURI = request.getRequestURI();
        if (this.properties.getIgnorePaths() != null) {
            AntPathMatcher apiMatcher = new AntPathMatcher();
            for (String path : this.properties.getIgnorePaths()) {
                if (!apiMatcher.match(path, requestURI)) continue;
                this.logger.trace("[udp-cloud]: ignored path: {}", (Object)requestURI);
                return true;
            }
        }
        if ((bestMatchingObject = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)) != null) {
            requestURI = bestMatchingObject.toString();
        }
        String method = request.getMethod().toUpperCase();
        String urlKey = method + ":" + requestURI;
        if (this.properties.getApis() == null || !this.properties.getApis().contains(urlKey)) {
            this.logger.info("[udp-cloud]: limit api: {}", (Object)requestURI);
            throw new UcApiLimitException(HttpStatus.FORBIDDEN, "API limit");
        }
        this.logger.trace("[udp-cloud]: pass api: {}", (Object)requestURI);
        return true;
    }
}

