/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.actuate.iplimit.filter;

import cn.com.yusys.udp.cloud.actuate.iplimit.UcActuateIpLimitProperties;
import cn.com.yusys.udp.cloud.commons.util.UcWebIpUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpStatus;

public class UcActuateIpLimitWebFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServerProperties serverProperties;
    private final UcActuateIpLimitProperties properties;

    public UcActuateIpLimitWebFilter(ServerProperties serverProperties, UcActuateIpLimitProperties properties) {
        this.serverProperties = serverProperties;
        this.properties = properties;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.properties.getWhiteIps() == null || this.properties.getWhiteIps().size() == 0) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String ip = UcWebIpUtils.getIp((HttpServletRequest)httpServletRequest, (boolean)this.properties.isWithProxy());
        if (ip == null) {
            this.logger.error("[udp-cloud]: {} address not found", (Object)"");
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR, httpServletRequest, response);
            return;
        }
        List<String> whiteIps = this.properties.getWhiteIps();
        for (String whiteIp : whiteIps) {
            if (!ip.equals(whiteIp.trim())) continue;
            chain.doFilter(request, response);
            this.logger.trace(ip + " be allowed to request actuator");
            return;
        }
        this.logger.warn("[udp-cloud]: {} be not allowed to request actuator", (Object)ip);
        this.handleError(HttpStatus.FORBIDDEN, httpServletRequest, response);
    }

    private void handleError(HttpStatus httpStatus, HttpServletRequest request, ServletResponse response) throws ServletException, IOException {
        request.setAttribute("javax.servlet.error.status_code", (Object)httpStatus.value());
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        request.setAttribute("javax.servlet.error.message", (Object)httpStatus.toString());
        request.getRequestDispatcher(this.serverProperties.getError().getPath()).forward((ServletRequest)request, response);
    }
}

