/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.actuate.iplimit.filter;

import cn.com.yusys.udp.cloud.actuate.iplimit.UcActuateIpLimitProperties;
import cn.com.yusys.udp.cloud.commons.exception.UcException;
import cn.com.yusys.udp.cloud.commons.util.UcWebFluxIpUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class UcgActuateIpLimitWebFluxFilter
implements WebFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final WebEndpointProperties webEndpointProperties;
    private final UcActuateIpLimitProperties properties;

    public UcgActuateIpLimitWebFluxFilter(WebEndpointProperties webEndpointProperties, UcActuateIpLimitProperties properties) {
        this.webEndpointProperties = webEndpointProperties;
        this.properties = properties;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getPath().toString();
        if (!path.startsWith(this.webEndpointProperties.getBasePath())) {
            return chain.filter(exchange);
        }
        if (this.properties.getWhiteIps() == null || this.properties.getWhiteIps().size() == 0) {
            return chain.filter(exchange);
        }
        String ip = UcWebFluxIpUtils.getIp((ServerHttpRequest)exchange.getRequest(), (boolean)this.properties.isWithProxy());
        if (ip == null) {
            this.logger.error("[udp-cloud]: {} address not found", (Object)"");
            throw new UcException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        List<String> whiteIps = this.properties.getWhiteIps();
        for (String whiteIp : whiteIps) {
            if (!ip.equals(whiteIp.trim())) continue;
            this.logger.trace(ip + " be allowed to request actuator");
            return chain.filter(exchange);
        }
        throw new UcException(HttpStatus.FORBIDDEN);
    }
}

