/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.actuate.iplimit.filter;

import cn.com.yusys.udp.cloud.actuate.iplimit.UcActuateIpLimitProperties;
import cn.com.yusys.udp.cloud.commons.exception.UcException;
import cn.com.yusys.udp.cloud.commons.util.UcWebIpUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class UcActuateIpLimitWebFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UcActuateIpLimitProperties properties;

    public UcActuateIpLimitWebFilter(UcActuateIpLimitProperties properties) {
        this.properties = properties;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.properties.getWhiteIps() == null || this.properties.getWhiteIps().size() == 0) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String ip = UcWebIpUtils.getIp((HttpServletRequest)httpServletRequest, (boolean)this.properties.isWithProxy());
        if (ip == null) {
            this.logger.error("[udp-cloud]: {} address not found", (Object)"");
            throw new UcException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        List<String> whiteIps = this.properties.getWhiteIps();
        for (String whiteIp : whiteIps) {
            if (!ip.equals(whiteIp.trim())) continue;
            chain.doFilter(request, response);
            this.logger.trace(ip + " be allowed to request actuator");
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        this.logger.warn("[udp-cloud]: {} be not allowed to request actuator", (Object)ip);
        PrintWriter writer = httpServletResponse.getWriter();
        httpServletResponse.setStatus(HttpStatus.FORBIDDEN.value());
        writer.print(HttpStatus.FORBIDDEN);
    }
}

