/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.sequence.client;

import cn.com.yusys.icsp.commons.web.rest.req.IcspRequest;
import cn.com.yusys.icsp.sequence.client.SequenceTemplateClient;
import cn.com.yusys.icsp.sequence.common.entity.SequenceConfigSeqIdRelation;
import cn.com.yusys.icsp.sequence.common.exception.SequenceConfigException;
import cn.com.yusys.icsp.sequence.common.util.SequenceConfigUtil;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class SequenceTemplateService {
    @Autowired
    private SequenceTemplateClient sequenceTemplateClient;
    private static ConcurrentHashMap<String, Queue<String>> nextSequenceTemplateMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Queue<String>> nextSequenceDayMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Queue<String>> nextSequenceYearMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Queue<String>> nextSequenceMonthMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SequenceConfigSeqIdRelation> sequenceConfigMap = new ConcurrentHashMap();
    @Value(value="${application.seqconfig.cache:20}")
    private Integer count;

    public String getNextSeq(String seqId) throws Exception {
        return this.getSequence(seqId);
    }

    public String getSequenceTemplate(String seqId, Map<String, String> paramsMap) throws Exception {
        String sequence = this.getSequence(seqId);
        sequence = this.resetSequence(seqId, sequence, paramsMap);
        return sequence;
    }

    private String getSequence(String seqId) throws Exception {
        String sequence = "";
        String newSeq = this.getNewSeqIdByoldSeq(seqId);
        sequence = StringUtils.isEmpty((Object)newSeq) ? this.getSequenceByMap(seqId) : this.getSequenceByMap(newSeq);
        if (StringUtils.isEmpty((Object)sequence)) {
            this.getSequenceByRest(seqId);
            newSeq = this.getNewSeqIdByoldSeq(seqId);
            sequence = StringUtils.isEmpty((Object)newSeq) ? this.getSequenceByMap(seqId) : this.getSequenceByMap(newSeq);
        }
        return sequence;
    }

    private String resetSequence(String seqId, String sequence, Map<String, String> paramsMap) throws Exception {
        SequenceConfigSeqIdRelation sequenceConfigSeqIdRelation = sequenceConfigMap.get(seqId);
        if (ObjectUtils.isEmpty((Object)sequenceConfigSeqIdRelation)) {
            IcspRequest request = new IcspRequest();
            request.setBody((Object)seqId);
            sequenceConfigSeqIdRelation = (SequenceConfigSeqIdRelation)this.sequenceTemplateClient.getSequenceConfigSeqIdRelationBySeqId((IcspRequest<String>)request).getBody();
            if (ObjectUtils.isEmpty((Object)sequenceConfigSeqIdRelation)) {
                throw new SequenceConfigException("not found sequenceConfig : " + seqId);
            }
            sequenceConfigMap.put(seqId, sequenceConfigSeqIdRelation);
        }
        if (!StringUtils.isEmpty((Object)sequenceConfigSeqIdRelation.getSeqTemplet())) {
            sequence = SequenceConfigUtil.dealWithSeq2Templet((String)sequence, (String)sequenceConfigSeqIdRelation.getZeroFill(), (String)sequenceConfigSeqIdRelation.getSeqTemplet(), (Long)sequenceConfigSeqIdRelation.getSeqPlace().longValue(), paramsMap);
        }
        return sequence;
    }

    private String getNewSeqIdByoldSeq(String seqId) throws SequenceConfigException {
        SequenceConfigSeqIdRelation sequenceConfigSeqIdRelation = sequenceConfigMap.get(seqId);
        if (!ObjectUtils.isEmpty((Object)sequenceConfigSeqIdRelation) && !StringUtils.isEmpty((Object)sequenceConfigSeqIdRelation.getResetType())) {
            String newSeqid = SequenceConfigUtil.resetSeqId((String)seqId, (String)sequenceConfigSeqIdRelation.getResetType());
            sequenceConfigMap.put(newSeqid, sequenceConfigSeqIdRelation);
            return newSeqid;
        }
        return "";
    }

    private String getSequenceByMap(String seqId) {
        String nextSequence = "";
        SequenceConfigSeqIdRelation sequenceConfigSeqIdRelation = sequenceConfigMap.get(seqId);
        if (ObjectUtils.isEmpty((Object)sequenceConfigSeqIdRelation) || StringUtils.isEmpty((Object)sequenceConfigSeqIdRelation.getResetType())) {
            return nextSequence;
        }
        if ("DAY".equals(sequenceConfigSeqIdRelation.getResetType())) {
            if (!CollectionUtils.isEmpty((Collection)nextSequenceDayMap.get(seqId))) {
                nextSequence = nextSequenceDayMap.get(seqId).poll();
            }
        } else if ("MONTH".equals(sequenceConfigSeqIdRelation.getResetType())) {
            if (!CollectionUtils.isEmpty((Collection)nextSequenceMonthMap.get(seqId))) {
                nextSequence = nextSequenceMonthMap.get(seqId).poll();
            }
        } else if ("YEAR".equals(sequenceConfigSeqIdRelation.getResetType())) {
            if (!CollectionUtils.isEmpty((Collection)nextSequenceYearMap.get(seqId))) {
                nextSequence = nextSequenceYearMap.get(seqId).poll();
            }
        } else if (!CollectionUtils.isEmpty((Collection)nextSequenceTemplateMap.get(seqId))) {
            nextSequence = nextSequenceTemplateMap.get(seqId).poll();
        }
        return nextSequence;
    }

    private void getSequenceByRest(String seqId) throws Exception {
        IcspRequest request = new IcspRequest();
        request.setBody((Object)seqId);
        List sequenceTemplateList = (List)this.sequenceTemplateClient.getNextSeqWithCount((IcspRequest<String>)request).getBody();
        SequenceConfigSeqIdRelation sequenceConfigSeqIdRelation = sequenceConfigMap.get(seqId);
        if (ObjectUtils.isEmpty((Object)sequenceConfigSeqIdRelation) && !ObjectUtils.isEmpty((Object)(sequenceConfigSeqIdRelation = (SequenceConfigSeqIdRelation)this.sequenceTemplateClient.getSequenceConfigSeqIdRelationBySeqId((IcspRequest<String>)request).getBody()))) {
            sequenceConfigMap.put(seqId, sequenceConfigSeqIdRelation);
        }
        if (ObjectUtils.isEmpty((Object)sequenceConfigSeqIdRelation) || CollectionUtils.isEmpty((Collection)sequenceTemplateList)) {
            throw new SequenceConfigException("\u670d\u52a1\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u5f97\u8be5\u5e8f\u5217\u53f7:" + seqId);
        }
        if (sequenceConfigSeqIdRelation.getResetType().equals("DAY")) {
            this.setMap(seqId, sequenceTemplateList, nextSequenceDayMap, "DAY");
        } else if (sequenceConfigSeqIdRelation.getResetType().equals("MONTH")) {
            this.setMap(seqId, sequenceTemplateList, nextSequenceMonthMap, "MONTH");
        } else if (sequenceConfigSeqIdRelation.getResetType().equals("YEAR")) {
            this.setMap(seqId, sequenceTemplateList, nextSequenceYearMap, "YEAR");
        } else {
            this.setMap(seqId, sequenceTemplateList, nextSequenceTemplateMap, null);
        }
    }

    private void setMap(String seqId, List<String> nextSequencelist, ConcurrentHashMap<String, Queue<String>> nextSequenceDayMap, String type) throws SequenceConfigException {
        if (CollectionUtils.isEmpty((Collection)nextSequenceDayMap.get(seqId = SequenceConfigUtil.resetSeqId((String)seqId, (String)type)))) {
            nextSequenceDayMap.put(seqId, new ConcurrentLinkedQueue());
        }
        nextSequenceDayMap.get(seqId).addAll(nextSequencelist);
    }

    public void remove(String type) {
        if (type.equals("DAY")) {
            this.remove(nextSequenceDayMap, "DAY");
        } else if (type.equals("MONTH")) {
            this.remove(nextSequenceMonthMap, "MONTH");
        } else if (type.equals("YEAR")) {
            this.remove(nextSequenceYearMap, "YEAR");
        }
    }

    private void remove(Map<String, Queue<String>> map, String Type) {
        if (!CollectionUtils.isEmpty(map)) {
            Iterator<Map.Entry<String, Queue<String>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Queue<String>> entry = iterator.next();
                String dateformat = entry.getKey();
                if (!dateformat.contains("#")) continue;
                String date = dateformat.split("#")[0].split("S")[1];
                try {
                    if (SequenceConfigUtil.getDayDiffer((String)date, (String)Type) <= 1) continue;
                    iterator.remove();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

