/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.log.common.constant;

import cn.com.yusys.icsp.commons.log.common.constant.MargicNumberConstant;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonEnum<T extends CommonEnum>
implements Comparable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CommonEnum.class);
    private static final long serialVersionUID = -3452282958188035040L;
    private static final Map<String, CommonEnum> EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static Map<Class<CommonEnum>, Entry> cEnumClasses = new WeakHashMap<Class<CommonEnum>, Entry>();
    private String name;
    private String cname;
    private Number value;
    private String desc;

    public static CommonEnum create() {
        return CommonEnum.create(null, null, null, null);
    }

    public static CommonEnum create(String name) {
        return CommonEnum.create(name, null, null, null);
    }

    public static CommonEnum create(String name, Number value) {
        return CommonEnum.create(name, value, null, null);
    }

    public static CommonEnum create(Number value, String cname) {
        return CommonEnum.create(null, value, cname, null);
    }

    public static CommonEnum create(String name, Number value, String cname) {
        return CommonEnum.create(name, value, cname, null);
    }

    public static CommonEnum create(String name, Number value, String cname, String desc) {
        CommonEnum menum = CommonEnum.init(name);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            menum.name = name;
        }
        menum.cname = cname;
        menum.value = value;
        menum.desc = desc;
        return menum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommonEnum init(String name) {
        try {
            Class enumClass = ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)CommonEnum.getCallerClassName());
            if (enumClass == null) {
                throw new IllegalArgumentException("EnumClass must not be null");
            }
            Class<CommonEnum> var3 = CommonEnum.class;
            Class<CommonEnum> clazz = CommonEnum.class;
            synchronized (CommonEnum.class) {
                Entry entry = cEnumClasses.get(enumClass);
                if (entry == null) {
                    entry = CommonEnum.createEntry(enumClass);
                    WeakHashMap<Class<CommonEnum>, Entry> myMap = new WeakHashMap<Class<CommonEnum>, Entry>();
                    myMap.putAll(cEnumClasses);
                    myMap.put(enumClass, entry);
                    cEnumClasses = myMap;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                CommonEnum enumObject = (CommonEnum)enumClass.newInstance();
                if (StringUtils.isNotEmpty((CharSequence)name)) {
                    if (entry.map.containsKey(name)) {
                        throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added");
                    }
                    enumObject.name = name;
                    entry.map.put(name, enumObject);
                }
                entry.list.add(enumObject);
                return enumObject;
            }
        }
        catch (Exception var7) {
            log.error(var7.getMessage());
            return null;
        }
    }

    private static String getCallerClassName() {
        StackTraceElement[] callers = new Throwable().getStackTrace();
        String enumClass = CommonEnum.class.getName();
        StackTraceElement[] var2 = callers;
        int var3 = callers.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            StackTraceElement caller = var2[var4];
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            if (enumClass.equals(className) || !"<clinit>".equals(methodName)) continue;
            return className;
        }
        throw new IllegalArgumentException("");
    }

    protected Object readResolve() {
        Entry entry = cEnumClasses.get(this.getEnumClass());
        return entry == null ? null : entry.map.get(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getEnumClass() {
        Class<?> enumClass;
        Class<?> clazz = enumClass = this.getClass();
        synchronized (clazz) {
            return enumClass;
        }
    }

    private static <T> Entry getEntry(Class<T> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!CommonEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = cEnumClasses.get(enumClass);
        if (entry == null) {
            try {
                Class.forName(enumClass.getName(), true, enumClass.getClassLoader());
                entry = cEnumClasses.get(enumClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entry;
    }

    private static Entry createEntry(Class enumClass) {
        Entry entry = new Entry();
        for (Class cls = enumClass.getSuperclass(); cls != null && cls != CommonEnum.class; cls = cls.getSuperclass()) {
            Entry loopEntry = cEnumClasses.get(cls);
            if (loopEntry == null) continue;
            entry.list.addAll(loopEntry.list);
            entry.map.putAll(loopEntry.map);
            break;
        }
        return entry;
    }

    public static <T> CommonEnum getEnum(Class<T> enumClass, String name) {
        Entry entry = CommonEnum.getEntry(enumClass);
        return entry == null ? null : entry.map.get(name);
    }

    public static <T> CommonEnum getEnum(Class<T> enumClass, Number value) {
        CommonEnum enumeration;
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = CommonEnum.getEnumList(enumClass);
        Iterator it = list.iterator();
        do {
            if (it.hasNext()) continue;
            return null;
        } while ((enumeration = (CommonEnum)it.next()).value() != value.intValue());
        return enumeration;
    }

    public static <T> CommonEnum getEnumByCnName(Class<T> enumClass, String cnName) {
        CommonEnum enumeration;
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = CommonEnum.getEnumList(enumClass);
        Iterator it = list.iterator();
        do {
            if (!it.hasNext()) {
                return null;
            }
            enumeration = (CommonEnum)it.next();
        } while (!enumeration.cname.equalsIgnoreCase(cnName));
        return enumeration;
    }

    public static <T> Map<String, CommonEnum> getEnumMap(Class<T> enumClass) {
        Entry entry = CommonEnum.getEntry(enumClass);
        return entry == null ? EMPTY_MAP : entry.unmodifiableMap;
    }

    public static <T> List getEnumList(Class<T> enumClass) {
        Entry entry = CommonEnum.getEntry(enumClass);
        return entry == null ? Collections.EMPTY_LIST : entry.unmodifiableList;
    }

    protected static Iterator<CommonEnum> iterator(Class<CommonEnum> enumClass) {
        return CommonEnum.getEnumList(enumClass).iterator();
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.name.equals(((CommonEnum)other).name);
        }
        return other.getClass().getName().equals(this.getClass().getName());
    }

    public int compareTo(Object other) {
        if (other.equals(this)) {
            return 0;
        }
        if (other.getClass() != this.getClass()) {
            throw new ClassCastException("Different enum class '" + ClassUtils.getShortClassName(other.getClass()) + "'");
        }
        return this.name.compareTo(((CommonEnum)other).name);
    }

    public boolean isIn(Class<T> enumClass, int value) {
        CommonEnum enumeration;
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = CommonEnum.getEnumList(enumClass);
        Iterator it = list.iterator();
        do {
            if (it.hasNext()) continue;
            return false;
        } while ((enumeration = (CommonEnum)it.next()).getValue().intValue() != value);
        return true;
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode();
    }

    public final int value() {
        return this.value.intValue();
    }

    public final byte byteValue() {
        return this.value.byteValue();
    }

    public final short shortValue() {
        return this.value.shortValue();
    }

    public final long longValue() {
        return this.value.longValue();
    }

    public final String name() {
        if (this.name == null) {
            Class enumClass = this.getEnumClass();
            Entry entry = cEnumClasses.get(this.getEnumClass());
            entry.populateNames(enumClass);
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Number getValue() {
        return this.value;
    }

    public String getCname() {
        return this.cname;
    }

    public String getDesc() {
        return this.desc;
    }

    private static class Entry {
        final Map<String, CommonEnum> map = new HashMap<String, CommonEnum>();
        final Map<String, CommonEnum> unmodifiableMap = Collections.unmodifiableMap(this.map);
        final List<CommonEnum> list = new ArrayList<CommonEnum>(MargicNumberConstant.n25);
        final List<CommonEnum> unmodifiableList = Collections.unmodifiableList(this.list);

        protected Entry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateNames(Class enumClass) {
            Class clazz = enumClass;
            synchronized (clazz) {
                Field[] fields;
                Field[] var4 = fields = enumClass.getFields();
                int var5 = fields.length;
                block5: for (int var6 = 0; var6 < var5; ++var6) {
                    Field field = var4[var6];
                    int modifier = field.getModifiers();
                    if (!Modifier.isPublic(modifier) || !Modifier.isFinal(modifier) || !Modifier.isStatic(modifier)) continue;
                    try {
                        Object value = field.get(null);
                        String fname = field.getName();
                        for (CommonEnum enumObject : this.unmodifiableList) {
                            if (value == null || !value.equals(enumObject) || enumObject.name != null || this.unmodifiableMap.containsKey(fname)) continue;
                            enumObject.name = fname;
                            this.map.put(fname, enumObject);
                            continue block5;
                        }
                        continue;
                    }
                    catch (Exception var14) {
                        log.error(var14.getMessage());
                    }
                }
            }
        }
    }
}

