/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.log.api.collect;

import cn.com.yusys.icsp.commons.log.api.ApiLogger;
import cn.com.yusys.icsp.commons.log.common.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.boot.actuate.trace.http.HttpTrace;
import org.springframework.boot.actuate.trace.http.InMemoryHttpTraceRepository;
import org.springframework.util.AntPathMatcher;

public class CustomInMemoryHttpTraceRepository
extends InMemoryHttpTraceRepository {
    private AntPathMatcher matcher = new AntPathMatcher();

    public void add(HttpTrace trace) {
        super.add(trace);
        if (trace.getResponse() != null) {
            JSONObject messageObject = new JSONObject();
            String transactionId = StringUtil.getUUID();
            String urlPath = trace.getRequest().getUri().getPath();
            long timestamp = Date.from(trace.getTimestamp()).getTime();
            int status = trace.getResponse().getStatus();
            messageObject.put("transactionId", (Object)transactionId);
            messageObject.put("logTimestamp", (Object)timestamp);
            messageObject.put("urlFull", (Object)trace.getRequest().getUri().toString());
            messageObject.put("urlPath", (Object)urlPath);
            messageObject.put("method", (Object)trace.getRequest().getMethod());
            messageObject.put("status", (Object)status);
            messageObject.put("timeTaken", (Object)trace.getTimeTaken());
            messageObject.put("contentLength", (Object)(trace.getRequest().getHeaders().get("Content-Length") == null ? Double.parseDouble("0") : Double.parseDouble((String)((List)trace.getRequest().getHeaders().get("Content-Length")).get(0))));
            if (status != 200) {
                messageObject.put("errorId", (Object)StringUtil.getUUID());
            }
            List<String> ignoreUrls = Arrays.asList("/favicon.ico");
            boolean flag = false;
            for (String urlPattern : ignoreUrls) {
                if (!this.matcher.match(urlPattern, urlPath)) continue;
                flag = true;
            }
            if (!flag) {
                ApiLogger.info(messageObject);
            }
        }
    }
}

