/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.file.fastdfs;

import cn.com.yusys.icsp.commons.file.fastdfs.ClientGlobal;
import cn.com.yusys.icsp.commons.file.fastdfs.ProtoCommon;
import cn.com.yusys.icsp.commons.file.fastdfs.ProtoStructDecoder;
import cn.com.yusys.icsp.commons.file.fastdfs.ServerInfo;
import cn.com.yusys.icsp.commons.file.fastdfs.StorageClient1;
import cn.com.yusys.icsp.commons.file.fastdfs.StorageServer;
import cn.com.yusys.icsp.commons.file.fastdfs.StructGroupStat;
import cn.com.yusys.icsp.commons.file.fastdfs.StructStorageStat;
import cn.com.yusys.icsp.commons.file.fastdfs.TrackerGroup;
import cn.com.yusys.icsp.commons.file.fastdfs.TrackerServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;

public class TrackerClient {
    protected TrackerGroup tracker_group;
    protected byte errno;

    public TrackerClient() {
        this.tracker_group = ClientGlobal.g_tracker_group;
    }

    public TrackerClient(TrackerGroup tracker_group) {
        this.tracker_group = tracker_group;
    }

    public byte getErrorCode() {
        return this.errno;
    }

    public TrackerServer getConnection() throws IOException {
        return this.tracker_group.getConnection();
    }

    public StorageServer getStoreStorage(TrackerServer trackerServer) throws IOException {
        String groupName = null;
        return this.getStoreStorage(trackerServer, groupName);
    }

    public StorageServer getStoreStorage(TrackerServer trackerServer, String groupName) throws IOException {
        StorageServer var28;
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            byte[] bGroupName;
            int out_len;
            byte cmd;
            if (groupName != null && groupName.length() != 0) {
                cmd = 104;
                out_len = 16;
            } else {
                cmd = 101;
                out_len = 0;
            }
            byte[] header = ProtoCommon.packHeader(cmd, out_len, (byte)0);
            out.write(header);
            if (groupName != null && groupName.length() > 0) {
                byte[] bs = groupName.getBytes(ClientGlobal.g_charset);
                bGroupName = new byte[16];
                int group_len = bs.length <= 16 ? bs.length : 16;
                Arrays.fill(bGroupName, (byte)0);
                System.arraycopy(bs, 0, bGroupName, 0, group_len);
                out.write(bGroupName);
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, 40L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                Object var282 = null;
                bGroupName = var282;
                return bGroupName;
            }
            String ip_addr = new String(pkgInfo.body, 16, 15).trim();
            int port = (int)ProtoCommon.buff2long(pkgInfo.body, 31);
            byte store_path = pkgInfo.body[39];
            System.out.println("IP->" + ip_addr + ":" + port);
            var28 = new StorageServer(ip_addr, port, store_path);
        }
        catch (IOException var25) {
            throw var25;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException var23) {
                    var23.printStackTrace();
                }
            }
        }
        return var28;
    }

    public StorageServer[] getStoreStorages(TrackerServer trackerServer, String groupName) throws IOException {
        StorageServer[] results;
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            Object var37;
            int out_len;
            byte cmd;
            if (groupName != null && groupName.length() != 0) {
                cmd = 107;
                out_len = 16;
            } else {
                cmd = 106;
                out_len = 0;
            }
            byte[] header = ProtoCommon.packHeader(cmd, out_len, (byte)0);
            out.write(header);
            if (groupName != null && groupName.length() > 0) {
                byte[] bs = groupName.getBytes(ClientGlobal.g_charset);
                byte[] bGroupName = new byte[16];
                int group_len = bs.length <= 16 ? bs.length : 16;
                Arrays.fill(bGroupName, (byte)0);
                System.arraycopy(bs, 0, bGroupName, 0, group_len);
                out.write(bGroupName);
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                var37 = null;
                StorageServer[] group_len = var37;
                return group_len;
            }
            if (pkgInfo.body.length < 40) {
                this.errno = (byte)22;
                var37 = null;
                StorageServer[] group_len = var37;
                return group_len;
            }
            int ipPortLen = pkgInfo.body.length - 17;
            if (ipPortLen % 23 != 0) {
                this.errno = (byte)22;
                Object var39 = null;
                StorageServer[] storageServerArray = var39;
                return storageServerArray;
            }
            int serverCount = ipPortLen / 23;
            if (serverCount <= 16) {
                StorageServer[] var40;
                StorageServer[] results2 = new StorageServer[serverCount];
                byte store_path = pkgInfo.body[pkgInfo.body.length - 1];
                int offset = 16;
                for (int i = 0; i < serverCount; ++i) {
                    String ip_addr = new String(pkgInfo.body, offset, 15).trim();
                    int port = (int)ProtoCommon.buff2long(pkgInfo.body, offset += 15);
                    offset += 8;
                    results2[i] = new StorageServer(ip_addr, port, store_path);
                }
                StorageServer[] storageServerArray = var40 = results2;
                return storageServerArray;
            }
            this.errno = (byte)28;
            results = null;
        }
        catch (IOException var33) {
            throw var33;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException var31) {
                    var31.printStackTrace();
                }
            }
        }
        return results;
    }

    public StorageServer getFetchStorage(TrackerServer trackerServer, String groupName, String filename) throws IOException {
        ServerInfo[] servers = this.getStorages(trackerServer, (byte)102, groupName, filename);
        return servers == null ? null : new StorageServer(servers[0].getIpAddr(), servers[0].getPort(), 0);
    }

    public StorageServer getUpdateStorage(TrackerServer trackerServer, String groupName, String filename) throws IOException {
        ServerInfo[] servers = this.getStorages(trackerServer, (byte)103, groupName, filename);
        return servers == null ? null : new StorageServer(servers[0].getIpAddr(), servers[0].getPort(), 0);
    }

    public ServerInfo[] getFetchStorages(TrackerServer trackerServer, String groupName, String filename) throws IOException {
        return this.getStorages(trackerServer, (byte)105, groupName, filename);
    }

    protected ServerInfo[] getStorages(TrackerServer trackerServer, byte cmd, String groupName, String filename) throws IOException {
        Object var17;
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            byte[] bs = groupName.getBytes(ClientGlobal.g_charset);
            byte[] bGroupName = new byte[16];
            byte[] bFileName = filename.getBytes(ClientGlobal.g_charset);
            int len = bs.length <= 16 ? bs.length : 16;
            Arrays.fill(bGroupName, (byte)0);
            System.arraycopy(bs, 0, bGroupName, 0, len);
            byte[] header = ProtoCommon.packHeader(cmd, 16 + bFileName.length, (byte)0);
            byte[] wholePkg = new byte[header.length + bGroupName.length + bFileName.length];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(bGroupName, 0, wholePkg, header.length, bGroupName.length);
            System.arraycopy(bFileName, 0, wholePkg, header.length + bGroupName.length, bFileName.length);
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno == 0) {
                ServerInfo[] var36;
                if (pkgInfo.body.length < 39) {
                    throw new IOException("Invalid body length: " + pkgInfo.body.length);
                }
                if ((pkgInfo.body.length - 39) % 15 != 0) {
                    throw new IOException("Invalid body length: " + pkgInfo.body.length);
                }
                int server_count = 1 + (pkgInfo.body.length - 39) / 15;
                String ip_addr = new String(pkgInfo.body, 16, 15).trim();
                int offset = 31;
                int port = (int)ProtoCommon.buff2long(pkgInfo.body, offset);
                offset += 8;
                ServerInfo[] servers = new ServerInfo[server_count];
                servers[0] = new ServerInfo(ip_addr, port);
                for (int i = 1; i < server_count; ++i) {
                    servers[i] = new ServerInfo(new String(pkgInfo.body, offset, 15).trim(), port);
                    offset += 15;
                }
                ServerInfo[] serverInfoArray = var36 = servers;
                return serverInfoArray;
            }
            var17 = null;
        }
        catch (IOException var32) {
            throw var32;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException var30) {
                    var30.printStackTrace();
                }
            }
        }
        return var17;
    }

    public StorageServer getFetchStorage1(TrackerServer trackerServer, String file_id) throws IOException {
        String[] parts = new String[2];
        this.errno = StorageClient1.split_file_id(file_id, parts);
        return this.errno != 0 ? null : this.getFetchStorage(trackerServer, parts[0], parts[1]);
    }

    public ServerInfo[] getFetchStorages1(TrackerServer trackerServer, String file_id) throws IOException {
        String[] parts = new String[2];
        this.errno = StorageClient1.split_file_id(file_id, parts);
        return this.errno != 0 ? null : this.getFetchStorages(trackerServer, parts[0], parts[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructGroupStat[] listGroups(TrackerServer trackerServer) throws IOException {
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            byte[] header = ProtoCommon.packHeader((byte)91, 0L, (byte)0);
            out.write(header);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno == 0) {
                StructGroupStat[] var13;
                ProtoStructDecoder decoder = new ProtoStructDecoder();
                StructGroupStat[] structGroupStatArray = var13 = (StructGroupStat[])decoder.decode(pkgInfo.body, StructGroupStat.class, StructGroupStat.getFieldsTotalSize());
                return structGroupStatArray;
            }
            StructGroupStat[] structGroupStatArray = null;
            return structGroupStatArray;
        }
        catch (IOException var27) {
            throw var27;
        }
        catch (Exception var28) {
            var28.printStackTrace();
            this.errno = (byte)22;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException var25) {
                    var25.printStackTrace();
                }
            }
        }
        return null;
    }

    public StructStorageStat[] listStorages(TrackerServer trackerServer, String groupName) throws IOException {
        String storageIpAddr = null;
        return this.listStorages(trackerServer, groupName, storageIpAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructStorageStat[] listStorages(TrackerServer trackerServer, String groupName, String storageIpAddr) throws IOException {
        StructStorageStat[] var16;
        boolean bNewConnection;
        if (trackerServer == null) {
            trackerServer = this.getConnection();
            if (trackerServer == null) {
                return null;
            }
            bNewConnection = true;
        } else {
            bNewConnection = false;
        }
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        try {
            int ipAddrLen;
            byte[] bIpAddr;
            byte[] bs = groupName.getBytes(ClientGlobal.g_charset);
            byte[] bGroupName = new byte[16];
            int len = bs.length <= 16 ? bs.length : 16;
            Arrays.fill(bGroupName, (byte)0);
            System.arraycopy(bs, 0, bGroupName, 0, len);
            if (storageIpAddr != null && storageIpAddr.length() > 0) {
                bIpAddr = storageIpAddr.getBytes(ClientGlobal.g_charset);
                ipAddrLen = bIpAddr.length < 16 ? bIpAddr.length : 15;
            } else {
                bIpAddr = null;
                ipAddrLen = 0;
            }
            byte[] header = ProtoCommon.packHeader((byte)92, 16 + ipAddrLen, (byte)0);
            byte[] wholePkg = new byte[header.length + bGroupName.length + ipAddrLen];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(bGroupName, 0, wholePkg, header.length, bGroupName.length);
            if (ipAddrLen > 0) {
                System.arraycopy(bIpAddr, 0, wholePkg, header.length + bGroupName.length, ipAddrLen);
            }
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                StructStorageStat[] structStorageStatArray = null;
                return structStorageStatArray;
            }
            ProtoStructDecoder decoder = new ProtoStructDecoder();
            var16 = (StructStorageStat[])decoder.decode(pkgInfo.body, StructStorageStat.class, StructStorageStat.getFieldsTotalSize());
        }
        catch (IOException var30) {
            throw var30;
        }
        catch (Exception var31) {
            var31.printStackTrace();
            this.errno = (byte)22;
            Object var12 = null;
            StructStorageStat[] structStorageStatArray = var12;
            return structStorageStatArray;
        }
        finally {
            if (bNewConnection) {
                try {
                    trackerServer.close();
                }
                catch (IOException var28) {
                    var28.printStackTrace();
                }
            }
        }
        return var16;
    }

    private boolean deleteStorage(TrackerServer trackerServer, String groupName, String storageIpAddr) throws IOException {
        Socket trackerSocket = trackerServer.getSocket();
        OutputStream out = trackerSocket.getOutputStream();
        byte[] bs = groupName.getBytes(ClientGlobal.g_charset);
        byte[] bGroupName = new byte[16];
        int len = bs.length <= 16 ? bs.length : 16;
        Arrays.fill(bGroupName, (byte)0);
        System.arraycopy(bs, 0, bGroupName, 0, len);
        byte[] bIpAddr = storageIpAddr.getBytes(ClientGlobal.g_charset);
        int ipAddrLen = bIpAddr.length < 16 ? bIpAddr.length : 15;
        byte[] header = ProtoCommon.packHeader((byte)93, 16 + ipAddrLen, (byte)0);
        byte[] wholePkg = new byte[header.length + bGroupName.length + ipAddrLen];
        System.arraycopy(header, 0, wholePkg, 0, header.length);
        System.arraycopy(bGroupName, 0, wholePkg, header.length, bGroupName.length);
        System.arraycopy(bIpAddr, 0, wholePkg, header.length + bGroupName.length, ipAddrLen);
        out.write(wholePkg);
        ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(trackerSocket.getInputStream(), (byte)100, 0L);
        this.errno = pkgInfo.errno;
        return pkgInfo.errno == 0;
    }

    public boolean deleteStorage(String groupName, String storageIpAddr) throws IOException {
        return this.deleteStorage(ClientGlobal.g_tracker_group, groupName, storageIpAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteStorage(TrackerGroup trackerGroup, String groupName, String storageIpAddr) throws IOException {
        TrackerServer trackerServer;
        int serverIndex;
        int notFoundCount = 0;
        for (serverIndex = 0; serverIndex < trackerGroup.tracker_servers.length; ++serverIndex) {
            try {
                trackerServer = trackerGroup.getConnection(serverIndex);
            }
            catch (IOException var37) {
                var37.printStackTrace(System.err);
                this.errno = (byte)61;
                return false;
            }
            try {
                boolean var8;
                StructStorageStat[] storageStats = this.listStorages(trackerServer, groupName, storageIpAddr);
                if (storageStats == null) {
                    if (this.errno != 2) {
                        boolean var82;
                        boolean bl = var82 = false;
                        return bl;
                    }
                    ++notFoundCount;
                    continue;
                }
                if (storageStats.length == 0) {
                    ++notFoundCount;
                    continue;
                }
                if (storageStats[0].getStatus() != 6 && storageStats[0].getStatus() != 7) continue;
                this.errno = (byte)16;
                boolean bl = var8 = false;
                return bl;
            }
            finally {
                try {
                    trackerServer.close();
                }
                catch (IOException var34) {
                    var34.printStackTrace();
                }
            }
        }
        if (notFoundCount == trackerGroup.tracker_servers.length) {
            this.errno = (byte)2;
            return false;
        }
        notFoundCount = 0;
        for (serverIndex = 0; serverIndex < trackerGroup.tracker_servers.length; ++serverIndex) {
            try {
                trackerServer = trackerGroup.getConnection(serverIndex);
            }
            catch (IOException var36) {
                System.err.println("connect to server " + trackerGroup.tracker_servers[serverIndex].getAddress().getHostAddress() + ":" + trackerGroup.tracker_servers[serverIndex].getPort() + " fail");
                var36.printStackTrace(System.err);
                this.errno = (byte)61;
                return false;
            }
            try {
                boolean var7;
                if (this.deleteStorage(trackerServer, groupName, storageIpAddr) || this.errno == 0) continue;
                if (this.errno == 2) {
                    ++notFoundCount;
                    continue;
                }
                if (this.errno == 114) continue;
                boolean bl = var7 = false;
                return bl;
            }
            finally {
                try {
                    trackerServer.close();
                }
                catch (IOException var35) {
                    var35.printStackTrace();
                }
            }
        }
        if (notFoundCount == trackerGroup.tracker_servers.length) {
            this.errno = (byte)2;
            return false;
        }
        if (this.errno == 2) {
            this.errno = 0;
        }
        return this.errno == 0;
    }
}

