/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.file.fastdfs;

import cn.com.yusys.icsp.commons.file.fastdfs.Base64;
import cn.com.yusys.icsp.commons.file.fastdfs.ClientGlobal;
import cn.com.yusys.icsp.commons.file.fastdfs.DownloadCallback;
import cn.com.yusys.icsp.commons.file.fastdfs.FileInfo;
import cn.com.yusys.icsp.commons.file.fastdfs.MyException;
import cn.com.yusys.icsp.commons.file.fastdfs.NameValuePair;
import cn.com.yusys.icsp.commons.file.fastdfs.ProtoCommon;
import cn.com.yusys.icsp.commons.file.fastdfs.StorageServer;
import cn.com.yusys.icsp.commons.file.fastdfs.TrackerClient;
import cn.com.yusys.icsp.commons.file.fastdfs.TrackerServer;
import cn.com.yusys.icsp.commons.file.fastdfs.UploadCallback;
import cn.com.yusys.icsp.commons.file.fastdfs.UploadStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;

public class StorageClient {
    public static final Base64 base64 = new Base64('-', '_', '.', 0);
    protected TrackerServer trackerServer;
    protected StorageServer storageServer;
    protected byte errno;

    public StorageClient() {
        this.trackerServer = null;
        this.storageServer = null;
    }

    public StorageClient(TrackerServer trackerServer, StorageServer storageServer) {
        this.trackerServer = trackerServer;
        this.storageServer = storageServer;
    }

    public byte getErrorCode() {
        return this.errno;
    }

    public String[] upload_file(String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_file(group_name, local_filename, file_ext_name, meta_list);
    }

    protected String[] upload_file(String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.upload_file((byte)11, group_name, local_filename, file_ext_name, meta_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] upload_file(byte cmd, String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String[] var12;
        int nPos;
        File f = new File(local_filename);
        FileInputStream fis = new FileInputStream(f);
        if (file_ext_name == null && (nPos = local_filename.lastIndexOf(46)) > 0 && local_filename.length() - nPos <= 7) {
            file_ext_name = local_filename.substring(nPos + 1);
        }
        try {
            var12 = this.do_upload_file(cmd, group_name, null, null, file_ext_name, f.length(), new UploadStream(fis, f.length()), meta_list);
        }
        finally {
            fis.close();
        }
        return var12;
    }

    public String[] upload_file(byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_file(group_name, file_buff, offset, length, file_ext_name, meta_list);
    }

    public String[] upload_file(String group_name, byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)11, group_name, null, null, file_ext_name, length, new UploadBuff(file_buff, offset, length), meta_list);
    }

    public String[] upload_file(byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_file(group_name, file_buff, 0, file_buff.length, file_ext_name, meta_list);
    }

    public String[] upload_file(String group_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)11, group_name, null, null, file_ext_name, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length), meta_list);
    }

    public String[] upload_file(String group_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String master_filename = null;
        String prefix_name = null;
        return this.do_upload_file((byte)11, group_name, master_filename, prefix_name, file_ext_name, file_size, callback, meta_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] upload_file(String group_name, String master_filename, String prefix_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        if (group_name != null && group_name.length() != 0 && master_filename != null && master_filename.length() != 0 && prefix_name != null) {
            String[] var13;
            int nPos;
            File f = new File(local_filename);
            FileInputStream fis = new FileInputStream(f);
            if (file_ext_name == null && (nPos = local_filename.lastIndexOf(46)) > 0 && local_filename.length() - nPos <= 7) {
                file_ext_name = local_filename.substring(nPos + 1);
            }
            try {
                var13 = this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, f.length(), new UploadStream(fis, f.length()), meta_list);
            }
            finally {
                fis.close();
            }
            return var13;
        }
        throw new MyException("invalid arguement");
    }

    public String[] upload_file(String group_name, String master_filename, String prefix_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        if (group_name != null && group_name.length() != 0 && master_filename != null && master_filename.length() != 0 && prefix_name != null) {
            return this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length), meta_list);
        }
        throw new MyException("invalid arguement");
    }

    public String[] upload_file(String group_name, String master_filename, String prefix_name, byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        if (group_name != null && group_name.length() != 0 && master_filename != null && master_filename.length() != 0 && prefix_name != null) {
            return this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, length, new UploadBuff(file_buff, offset, length), meta_list);
        }
        throw new MyException("invalid arguement");
    }

    public String[] upload_file(String group_name, String master_filename, String prefix_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)21, group_name, master_filename, prefix_name, file_ext_name, file_size, callback, meta_list);
    }

    public String[] upload_appender_file(String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_appender_file(group_name, local_filename, file_ext_name, meta_list);
    }

    protected String[] upload_appender_file(String group_name, String local_filename, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.upload_file((byte)23, group_name, local_filename, file_ext_name, meta_list);
    }

    public String[] upload_appender_file(byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_appender_file(group_name, file_buff, offset, length, file_ext_name, meta_list);
    }

    public String[] upload_appender_file(String group_name, byte[] file_buff, int offset, int length, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)23, group_name, null, null, file_ext_name, length, new UploadBuff(file_buff, offset, length), meta_list);
    }

    public String[] upload_appender_file(byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String group_name = null;
        return this.upload_appender_file(group_name, file_buff, 0, file_buff.length, file_ext_name, meta_list);
    }

    public String[] upload_appender_file(String group_name, byte[] file_buff, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        return this.do_upload_file((byte)23, group_name, null, null, file_ext_name, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length), meta_list);
    }

    public String[] upload_appender_file(String group_name, long file_size, UploadCallback callback, String file_ext_name, NameValuePair[] meta_list) throws IOException, MyException {
        String master_filename = null;
        String prefix_name = null;
        return this.do_upload_file((byte)23, group_name, master_filename, prefix_name, file_ext_name, file_size, callback, meta_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append_file(String group_name, String appender_filename, String local_filename) throws IOException, MyException {
        int var6;
        File f = new File(local_filename);
        try (FileInputStream fis = new FileInputStream(f);){
            var6 = this.do_append_file(group_name, appender_filename, f.length(), new UploadStream(fis, f.length()));
        }
        return var6;
    }

    public int append_file(String group_name, String appender_filename, byte[] file_buff) throws IOException, MyException {
        return this.do_append_file(group_name, appender_filename, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length));
    }

    public int append_file(String group_name, String appender_filename, byte[] file_buff, int offset, int length) throws IOException, MyException {
        return this.do_append_file(group_name, appender_filename, length, new UploadBuff(file_buff, offset, length));
    }

    public int append_file(String group_name, String appender_filename, long file_size, UploadCallback callback) throws IOException, MyException {
        return this.do_append_file(group_name, appender_filename, file_size, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int modify_file(String group_name, String appender_filename, long file_offset, String local_filename) throws IOException, MyException {
        int var8;
        File f = new File(local_filename);
        try (FileInputStream fis = new FileInputStream(f);){
            var8 = this.do_modify_file(group_name, appender_filename, file_offset, f.length(), new UploadStream(fis, f.length()));
        }
        return var8;
    }

    public int modify_file(String group_name, String appender_filename, long file_offset, byte[] file_buff) throws IOException, MyException {
        return this.do_modify_file(group_name, appender_filename, file_offset, file_buff.length, new UploadBuff(file_buff, 0, file_buff.length));
    }

    public int modify_file(String group_name, String appender_filename, long file_offset, byte[] file_buff, int buffer_offset, int buffer_length) throws IOException, MyException {
        return this.do_modify_file(group_name, appender_filename, file_offset, buffer_length, new UploadBuff(file_buff, buffer_offset, buffer_length));
    }

    public int modify_file(String group_name, String appender_filename, long file_offset, long modify_size, UploadCallback callback) throws IOException, MyException {
        return this.do_modify_file(group_name, appender_filename, file_offset, modify_size, callback);
    }

    /*
     * Exception decompiling
     */
    protected String[] do_upload_file(byte cmd, String group_name, String master_filename, String prefix_name, String file_ext_name, long file_size, UploadCallback callback, NameValuePair[] meta_list) throws IOException, MyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int do_append_file(String group_name, String appender_filename, long file_size, UploadCallback callback) throws IOException, MyException {
        if (group_name != null && group_name.length() != 0 && appender_filename != null && appender_filename.length() != 0) {
            boolean bNewConnection = this.newUpdatableStorageConnection(group_name, appender_filename);
            try {
                Socket storageSocket = this.storageServer.getSocket();
                byte[] appenderFilenameBytes = appender_filename.getBytes(ClientGlobal.g_charset);
                long body_len = (long)(16 + appenderFilenameBytes.length) + file_size;
                byte[] header = ProtoCommon.packHeader((byte)24, body_len, (byte)0);
                byte[] wholePkg = new byte[(int)((long)header.length + body_len - file_size)];
                System.arraycopy(header, 0, wholePkg, 0, header.length);
                int offset = header.length;
                byte[] hexLenBytes = ProtoCommon.long2buff(appender_filename.length());
                System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
                offset += hexLenBytes.length;
                hexLenBytes = ProtoCommon.long2buff(file_size);
                System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
                OutputStream out = storageSocket.getOutputStream();
                System.arraycopy(appenderFilenameBytes, 0, wholePkg, offset += hexLenBytes.length, appenderFilenameBytes.length);
                int var10000 = offset + appenderFilenameBytes.length;
                out.write(wholePkg);
                this.errno = (byte)callback.send(out);
                if (this.errno == 0) {
                    int var17;
                    ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, 0L);
                    this.errno = pkgInfo.errno;
                    if (pkgInfo.errno != 0) {
                        byte var98;
                        byte by = var98 = this.errno;
                        return by;
                    }
                    int n = var17 = 0;
                    return n;
                }
                byte var16 = this.errno;
                return var16;
            }
            catch (IOException var95) {
                throw var95;
            }
            finally {
                if (bNewConnection) {
                    try {
                        this.storageServer.close();
                    }
                    catch (IOException var91) {
                        var91.printStackTrace();
                    }
                    finally {
                        this.storageServer = null;
                    }
                }
            }
        }
        this.errno = (byte)22;
        return this.errno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int do_modify_file(String group_name, String appender_filename, long file_offset, long modify_size, UploadCallback callback) throws IOException, MyException {
        if (group_name != null && group_name.length() != 0 && appender_filename != null && appender_filename.length() != 0) {
            boolean bNewConnection = this.newUpdatableStorageConnection(group_name, appender_filename);
            try {
                Socket storageSocket = this.storageServer.getSocket();
                byte[] appenderFilenameBytes = appender_filename.getBytes(ClientGlobal.g_charset);
                long body_len = (long)(24 + appenderFilenameBytes.length) + modify_size;
                byte[] header = ProtoCommon.packHeader((byte)34, body_len, (byte)0);
                byte[] wholePkg = new byte[(int)((long)header.length + body_len - modify_size)];
                System.arraycopy(header, 0, wholePkg, 0, header.length);
                int offset = header.length;
                byte[] hexLenBytes = ProtoCommon.long2buff(appender_filename.length());
                System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
                offset += hexLenBytes.length;
                hexLenBytes = ProtoCommon.long2buff(file_offset);
                System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
                offset += hexLenBytes.length;
                hexLenBytes = ProtoCommon.long2buff(modify_size);
                System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
                OutputStream out = storageSocket.getOutputStream();
                System.arraycopy(appenderFilenameBytes, 0, wholePkg, offset += hexLenBytes.length, appenderFilenameBytes.length);
                int var10000 = offset + appenderFilenameBytes.length;
                out.write(wholePkg);
                this.errno = (byte)callback.send(out);
                if (this.errno != 0) {
                    byte var99;
                    byte by = var99 = this.errno;
                    return by;
                }
                ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, 0L);
                this.errno = pkgInfo.errno;
                if (pkgInfo.errno != 0) {
                    byte var100;
                    byte by = var100 = this.errno;
                    return by;
                }
                int var19 = 0;
                return var19;
            }
            catch (IOException var97) {
                throw var97;
            }
            finally {
                if (bNewConnection) {
                    try {
                        this.storageServer.close();
                    }
                    catch (IOException var93) {
                        var93.printStackTrace();
                    }
                    finally {
                        this.storageServer = null;
                    }
                }
            }
        }
        this.errno = (byte)22;
        return this.errno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete_file(String group_name, String remote_filename) throws IOException, MyException {
        boolean bNewConnection = this.newUpdatableStorageConnection(group_name, remote_filename);
        Socket storageSocket = this.storageServer.getSocket();
        try {
            this.send_package((byte)12, group_name, remote_filename);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, 0L);
            this.errno = pkgInfo.errno;
            byte var6 = pkgInfo.errno;
            return var6;
        }
        catch (IOException var47) {
            throw var47;
        }
        finally {
            if (bNewConnection) {
                try {
                    this.storageServer.close();
                }
                catch (IOException var43) {
                    var43.printStackTrace();
                }
                finally {
                    this.storageServer = null;
                }
            }
        }
    }

    public int truncate_file(String group_name, String appender_filename) throws IOException, MyException {
        long truncated_file_size = 0L;
        return this.truncate_file(group_name, appender_filename, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int truncate_file(String group_name, String appender_filename, long truncated_file_size) throws IOException, MyException {
        if (group_name != null && group_name.length() != 0 && appender_filename != null && appender_filename.length() != 0) {
            boolean bNewConnection = this.newUpdatableStorageConnection(group_name, appender_filename);
            try {
                Socket storageSocket = this.storageServer.getSocket();
                byte[] appenderFilenameBytes = appender_filename.getBytes(ClientGlobal.g_charset);
                int body_len = 16 + appenderFilenameBytes.length;
                byte[] header = ProtoCommon.packHeader((byte)36, body_len, (byte)0);
                byte[] wholePkg = new byte[header.length + body_len];
                System.arraycopy(header, 0, wholePkg, 0, header.length);
                int offset = header.length;
                byte[] hexLenBytes = ProtoCommon.long2buff(appender_filename.length());
                System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
                offset += hexLenBytes.length;
                hexLenBytes = ProtoCommon.long2buff(truncated_file_size);
                System.arraycopy(hexLenBytes, 0, wholePkg, offset, hexLenBytes.length);
                OutputStream out = storageSocket.getOutputStream();
                System.arraycopy(appenderFilenameBytes, 0, wholePkg, offset += hexLenBytes.length, appenderFilenameBytes.length);
                int var10000 = offset + appenderFilenameBytes.length;
                out.write(wholePkg);
                ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, 0L);
                this.errno = pkgInfo.errno;
                byte var15 = pkgInfo.errno;
                return var15;
            }
            catch (IOException var56) {
                throw var56;
            }
            finally {
                if (bNewConnection) {
                    try {
                        this.storageServer.close();
                    }
                    catch (IOException var52) {
                        var52.printStackTrace();
                    }
                    finally {
                        this.storageServer = null;
                    }
                }
            }
        }
        this.errno = (byte)22;
        return this.errno;
    }

    public byte[] download_file(String group_name, String remote_filename) throws IOException, MyException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.download_file(group_name, remote_filename, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] download_file(String group_name, String remote_filename, long file_offset, long download_bytes) throws IOException, MyException {
        boolean bNewConnection = this.newReadableStorageConnection(group_name, remote_filename);
        Socket storageSocket = this.storageServer.getSocket();
        try {
            this.send_download_package(group_name, remote_filename, file_offset, download_bytes);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno == 0) {
                byte[] var70;
                byte[] byArray = var70 = pkgInfo.body;
                return byArray;
            }
            Object var10 = null;
            return var10;
        }
        catch (IOException var68) {
            throw var68;
        }
        finally {
            if (bNewConnection) {
                try {
                    this.storageServer.close();
                }
                catch (IOException var64) {
                    var64.printStackTrace();
                }
                finally {
                    this.storageServer = null;
                }
            }
        }
    }

    public int download_file(String group_name, String remote_filename, String local_filename) throws IOException, MyException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.download_file(group_name, remote_filename, 0L, 0L, local_filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int download_file(String group_name, String remote_filename, long file_offset, long download_bytes, String local_filename) throws IOException, MyException {
        long remainBytes;
        byte[] buff;
        ProtoCommon.RecvHeaderInfo header;
        InputStream in;
        FileOutputStream out;
        boolean bNewConnection = this.newReadableStorageConnection(group_name, remote_filename);
        Socket storageSocket = this.storageServer.getSocket();
        try {
            out = new FileOutputStream(local_filename);
            try {
                this.errno = 0;
                this.send_download_package(group_name, remote_filename, file_offset, download_bytes);
                in = storageSocket.getInputStream();
                header = ProtoCommon.recvHeader(in, (byte)100, -1L);
                this.errno = header.errno;
                if (header.errno != 0) {
                    byte buf = header.errno;
                    return buf;
                }
                buff = new byte[262144];
                remainBytes = header.body_len;
            }
            catch (IOException var93) {
                if (this.errno != 0) throw var93;
                this.errno = (byte)5;
                throw var93;
            }
            finally {
                out.close();
                if (this.errno != 0) {
                    new File(local_filename).delete();
                }
            }
        }
        catch (IOException var95) {
            throw var95;
        }
        finally {
            if (bNewConnection) {
                try {
                    this.storageServer.close();
                }
                catch (IOException var89) {
                    var89.printStackTrace();
                }
                finally {
                    this.storageServer = null;
                }
            }
        }
        while (true) {
            if (remainBytes <= 0L) {
                int var17 = 0;
                return var17;
            }
            int bytes = in.read(buff, 0, remainBytes > (long)buff.length ? buff.length : (int)remainBytes);
            if (bytes < 0) {
                throw new IOException("recv package size " + (header.body_len - remainBytes) + " != " + header.body_len);
            }
            out.write(buff, 0, bytes);
            remainBytes -= (long)bytes;
        }
    }

    public int download_file(String group_name, String remote_filename, DownloadCallback callback) throws IOException, MyException {
        long file_offset = 0L;
        long download_bytes = 0L;
        return this.download_file(group_name, remote_filename, 0L, 0L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int download_file(String group_name, String remote_filename, long file_offset, long download_bytes, DownloadCallback callback) throws IOException, MyException {
        boolean bNewConnection = this.newReadableStorageConnection(group_name, remote_filename);
        Socket storageSocket = this.storageServer.getSocket();
        try {
            int var98;
            int bytes;
            this.send_download_package(group_name, remote_filename, file_offset, download_bytes);
            InputStream in = storageSocket.getInputStream();
            ProtoCommon.RecvHeaderInfo header = ProtoCommon.recvHeader(in, (byte)100, -1L);
            this.errno = header.errno;
            if (header.errno != 0) {
                byte var97;
                byte by = var97 = header.errno;
                return by;
            }
            byte[] buff = new byte[2048];
            for (long remainBytes = header.body_len; remainBytes > 0L; remainBytes -= (long)bytes) {
                int var17;
                bytes = in.read(buff, 0, remainBytes > (long)buff.length ? buff.length : (int)remainBytes);
                if (bytes < 0) {
                    throw new IOException("recv package size " + (header.body_len - remainBytes) + " != " + header.body_len);
                }
                int result = callback.recv(header.body_len, buff, bytes);
                if (result == 0) continue;
                this.errno = (byte)result;
                int n = var17 = result;
                return n;
            }
            int n = var98 = 0;
            return n;
        }
        catch (IOException var95) {
            throw var95;
        }
        finally {
            if (bNewConnection) {
                try {
                    this.storageServer.close();
                }
                catch (IOException var91) {
                    var91.printStackTrace();
                }
                finally {
                    this.storageServer = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameValuePair[] get_metadata(String group_name, String remote_filename) throws IOException, MyException {
        boolean bNewConnection = this.newUpdatableStorageConnection(group_name, remote_filename);
        Socket storageSocket = this.storageServer.getSocket();
        try {
            this.send_package((byte)15, group_name, remote_filename);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, -1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                NameValuePair[] var6;
                NameValuePair[] nameValuePairArray = var6 = null;
                return nameValuePairArray;
            }
            NameValuePair[] var6 = ProtoCommon.split_metadata(new String(pkgInfo.body, ClientGlobal.g_charset));
            return var6;
        }
        catch (IOException var64) {
            throw var64;
        }
        finally {
            if (bNewConnection) {
                try {
                    this.storageServer.close();
                }
                catch (IOException var60) {
                    var60.printStackTrace();
                }
                finally {
                    this.storageServer = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int set_metadata(String group_name, String remote_filename, NameValuePair[] meta_list, byte op_flag) throws IOException, MyException {
        boolean bNewConnection = this.newUpdatableStorageConnection(group_name, remote_filename);
        Socket storageSocket = this.storageServer.getSocket();
        try {
            byte[] meta_buff = meta_list == null ? new byte[]{} : ProtoCommon.pack_metadata(meta_list).getBytes(ClientGlobal.g_charset);
            byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
            byte[] sizeBytes = new byte[16];
            Arrays.fill(sizeBytes, (byte)0);
            byte[] bs = ProtoCommon.long2buff(filenameBytes.length);
            System.arraycopy(bs, 0, sizeBytes, 0, bs.length);
            bs = ProtoCommon.long2buff(meta_buff.length);
            System.arraycopy(bs, 0, sizeBytes, 8, bs.length);
            byte[] groupBytes = new byte[16];
            bs = group_name.getBytes(ClientGlobal.g_charset);
            Arrays.fill(groupBytes, (byte)0);
            int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
            System.arraycopy(bs, 0, groupBytes, 0, groupLen);
            byte[] header = ProtoCommon.packHeader((byte)13, 17 + groupBytes.length + filenameBytes.length + meta_buff.length, (byte)0);
            OutputStream out = storageSocket.getOutputStream();
            byte[] wholePkg = new byte[header.length + sizeBytes.length + 1 + groupBytes.length + filenameBytes.length];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(sizeBytes, 0, wholePkg, header.length, sizeBytes.length);
            wholePkg[header.length + sizeBytes.length] = op_flag;
            System.arraycopy(groupBytes, 0, wholePkg, header.length + sizeBytes.length + 1, groupBytes.length);
            System.arraycopy(filenameBytes, 0, wholePkg, header.length + sizeBytes.length + 1 + groupBytes.length, filenameBytes.length);
            out.write(wholePkg);
            if (meta_buff.length > 0) {
                out.write(meta_buff);
            }
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, 0L);
            this.errno = pkgInfo.errno;
            byte var17 = pkgInfo.errno;
            return var17;
        }
        catch (IOException var58) {
            throw var58;
        }
        finally {
            if (bNewConnection) {
                try {
                    this.storageServer.close();
                }
                catch (IOException var54) {
                    var54.printStackTrace();
                }
                finally {
                    this.storageServer = null;
                }
            }
        }
    }

    public FileInfo get_file_info(String group_name, String remote_filename) throws IOException, MyException {
        if (remote_filename.length() < 44) {
            this.errno = (byte)22;
            return null;
        }
        byte[] buff = base64.decodeAuto(remote_filename.substring(10, 37));
        long file_size = ProtoCommon.buff2long(buff, 8);
        if ((long)remote_filename.length() <= 60L && ((long)remote_filename.length() <= 44L || (file_size & 0x800000000000000L) != 0L) && (file_size & 0x400000000000000L) == 0L) {
            FileInfo fileInfo = new FileInfo(file_size, 0, 0, ProtoCommon.getIpAddress(buff, 0));
            fileInfo.setCreateTimestamp(ProtoCommon.buff2int(buff, 4));
            if (file_size >> 63 != 0L) {
                fileInfo.setFileSize(file_size &= 0xFFFFFFFFL);
            }
            fileInfo.setCrc32(ProtoCommon.buff2int(buff, 16));
            return fileInfo;
        }
        FileInfo fileInfo = this.query_file_info(group_name, remote_filename);
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileInfo query_file_info(String group_name, String remote_filename) throws IOException, MyException {
        boolean bNewConnection = this.newUpdatableStorageConnection(group_name, remote_filename);
        Socket storageSocket = this.storageServer.getSocket();
        try {
            byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
            byte[] groupBytes = new byte[16];
            byte[] bs = group_name.getBytes(ClientGlobal.g_charset);
            Arrays.fill(groupBytes, (byte)0);
            int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
            System.arraycopy(bs, 0, groupBytes, 0, groupLen);
            byte[] header = ProtoCommon.packHeader((byte)22, groupBytes.length + filenameBytes.length, (byte)0);
            OutputStream out = storageSocket.getOutputStream();
            byte[] wholePkg = new byte[header.length + groupBytes.length + filenameBytes.length];
            System.arraycopy(header, 0, wholePkg, 0, header.length);
            System.arraycopy(groupBytes, 0, wholePkg, header.length, groupBytes.length);
            System.arraycopy(filenameBytes, 0, wholePkg, header.length + groupBytes.length, filenameBytes.length);
            out.write(wholePkg);
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage(storageSocket.getInputStream(), (byte)100, 40L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                Object var77 = null;
                FileInfo fileInfo = var77;
                return fileInfo;
            }
            long file_size = ProtoCommon.buff2long(pkgInfo.body, 0);
            int create_timestamp = (int)ProtoCommon.buff2long(pkgInfo.body, 8);
            int crc32 = (int)ProtoCommon.buff2long(pkgInfo.body, 16);
            String source_ip_addr = new String(pkgInfo.body, 24, 16).trim();
            FileInfo var18 = new FileInfo(file_size, create_timestamp, crc32, source_ip_addr);
            return var18;
        }
        catch (IOException var75) {
            throw var75;
        }
        finally {
            if (bNewConnection) {
                try {
                    this.storageServer.close();
                }
                catch (IOException var71) {
                    var71.printStackTrace();
                }
                finally {
                    this.storageServer = null;
                }
            }
        }
    }

    protected boolean newWritableStorageConnection(String group_name) throws IOException, MyException {
        if (this.storageServer != null) {
            return false;
        }
        TrackerClient tracker = new TrackerClient();
        this.storageServer = tracker.getStoreStorage(this.trackerServer, group_name);
        if (this.storageServer == null) {
            throw new MyException("getStoreStorage fail, errno code: " + tracker.getErrorCode());
        }
        return true;
    }

    protected boolean newReadableStorageConnection(String group_name, String remote_filename) throws IOException, MyException {
        if (this.storageServer != null) {
            return false;
        }
        TrackerClient tracker = new TrackerClient();
        this.storageServer = tracker.getFetchStorage(this.trackerServer, group_name, remote_filename);
        if (this.storageServer == null) {
            throw new MyException("getStoreStorage fail, errno code: " + tracker.getErrorCode());
        }
        return true;
    }

    protected boolean newUpdatableStorageConnection(String group_name, String remote_filename) throws IOException, MyException {
        if (this.storageServer != null) {
            return false;
        }
        TrackerClient tracker = new TrackerClient();
        this.storageServer = tracker.getUpdateStorage(this.trackerServer, group_name, remote_filename);
        if (this.storageServer == null) {
            throw new MyException("getStoreStorage fail, errno code: " + tracker.getErrorCode());
        }
        return true;
    }

    protected void send_package(byte cmd, String group_name, String remote_filename) throws IOException {
        byte[] groupBytes = new byte[16];
        byte[] bs = group_name.getBytes(ClientGlobal.g_charset);
        byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
        Arrays.fill(groupBytes, (byte)0);
        int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
        System.arraycopy(bs, 0, groupBytes, 0, groupLen);
        byte[] header = ProtoCommon.packHeader(cmd, groupBytes.length + filenameBytes.length, (byte)0);
        byte[] wholePkg = new byte[header.length + groupBytes.length + filenameBytes.length];
        System.arraycopy(header, 0, wholePkg, 0, header.length);
        System.arraycopy(groupBytes, 0, wholePkg, header.length, groupBytes.length);
        System.arraycopy(filenameBytes, 0, wholePkg, header.length + groupBytes.length, filenameBytes.length);
        this.storageServer.getSocket().getOutputStream().write(wholePkg);
    }

    protected void send_download_package(String group_name, String remote_filename, long file_offset, long download_bytes) throws IOException {
        byte[] bsOffset = ProtoCommon.long2buff(file_offset);
        byte[] bsDownBytes = ProtoCommon.long2buff(download_bytes);
        byte[] groupBytes = new byte[16];
        byte[] bs = group_name.getBytes(ClientGlobal.g_charset);
        byte[] filenameBytes = remote_filename.getBytes(ClientGlobal.g_charset);
        Arrays.fill(groupBytes, (byte)0);
        int groupLen = bs.length <= groupBytes.length ? bs.length : groupBytes.length;
        System.arraycopy(bs, 0, groupBytes, 0, groupLen);
        byte[] header = ProtoCommon.packHeader((byte)14, bsOffset.length + bsDownBytes.length + groupBytes.length + filenameBytes.length, (byte)0);
        byte[] wholePkg = new byte[header.length + bsOffset.length + bsDownBytes.length + groupBytes.length + filenameBytes.length];
        System.arraycopy(header, 0, wholePkg, 0, header.length);
        System.arraycopy(bsOffset, 0, wholePkg, header.length, bsOffset.length);
        System.arraycopy(bsDownBytes, 0, wholePkg, header.length + bsOffset.length, bsDownBytes.length);
        System.arraycopy(groupBytes, 0, wholePkg, header.length + bsOffset.length + bsDownBytes.length, groupBytes.length);
        System.arraycopy(filenameBytes, 0, wholePkg, header.length + bsOffset.length + bsDownBytes.length + groupBytes.length, filenameBytes.length);
        this.storageServer.getSocket().getOutputStream().write(wholePkg);
    }

    public static class UploadBuff
    implements UploadCallback {
        private byte[] fileBuff;
        private int offset;
        private int length;

        public UploadBuff(byte[] fileBuff, int offset, int length) {
            this.fileBuff = fileBuff;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int send(OutputStream out) throws IOException {
            out.write(this.fileBuff, this.offset, this.length);
            return 0;
        }
    }
}

