/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.file.disk;

import cn.com.yusys.icsp.commons.file.FileManagementClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiskClient
implements FileManagementClient {
    private final Logger log = LoggerFactory.getLogger(LocalDiskClient.class);
    private String rootFolder = null;
    private int subFolderNum = 20;
    private InputStream inputStream;

    public void init(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public void initConnection() {
        if (this.rootFolder.endsWith("/") || this.rootFolder.endsWith("\\")) {
            this.rootFolder = this.rootFolder.substring(0, this.rootFolder.length() - 1);
        }
        this.createFolder(this.rootFolder);
    }

    private void createFolder(String folder) {
        File rfolder = new File(folder);
        if (!rfolder.exists()) {
            this.log.info(folder + " Folder does not exist, will be created automatically");
            if (rfolder.mkdirs()) {
                this.log.info(folder + " create folder successfully");
            } else {
                this.log.error(folder + " create folder failed");
            }
        }
    }

    public void closeConnection() {
        try {
            if (Objects.nonNull(this.inputStream)) {
                this.inputStream.close();
            }
        }
        catch (Exception var2) {
            this.log.error("Error closing output stream " + var2.getMessage() + "{}" + var2);
        }
    }

    public String uploadFile(File file) {
        return this.uploadFile(file, null);
    }

    public String uploadFile(File file, Map<String, String> metaList) {
        String var6;
        FileInputStream fileInputStream = null;
        try {
            String fileExtName = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            fileInputStream = new FileInputStream(file);
            byte[] buff = this.fileToByte(fileInputStream, file.length());
            var6 = this.uploadFile(buff, fileExtName, metaList);
        }
        catch (Exception var15) {
            throw new RuntimeException(var15);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException var14) {
                    var14.printStackTrace();
                }
            }
        }
        return var6;
    }

    public String uploadFile(byte[] buff, String fileExtName, Map<String, String> fileInfo) {
        int subFolder = new Random().nextInt(this.subFolderNum);
        int subSubFolder = new Random().nextInt(this.subFolderNum);
        String subFolderT = "" + subFolder + "/" + subSubFolder;
        String folder = this.rootFolder + "/" + subFolderT;
        this.createFolder(folder);
        String newFileName = this.generateNewFileName(fileExtName);
        File temp = new File(folder + "/" + newFileName);
        LocalDiskClient.byteToFile(buff, temp);
        return subFolderT + "/" + newFileName;
    }

    public Map<String, String> getFileInfo(String fileId) {
        this.log.error("This method is not supported for local disk storage: getFileInfo(String fileId)");
        return null;
    }

    public int updateFileInfo(String fileId, Map<String, String> fileInfos) {
        this.log.error("This method is not supported for local disk storage: updateFileInfo(String fileId, Map<String, String> fileInfos)");
        return 1;
    }

    public int deleteFile(String fileId) {
        this.checkFileId(fileId);
        File file = new File(this.rootFolder + "/" + fileId);
        if (file.exists()) {
            if (file.delete()) {
                this.log.debug(fileId + "Delete file successfully");
                return 0;
            }
            this.log.error(fileId + "Delete file failed");
            return 1;
        }
        this.log.error(fileId + " File does not exist, delete failed");
        return 1;
    }

    /*
     * Exception decompiling
     */
    public int downloadFile(String fileId, File outFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream downloadLargeFile(String fileId) {
        this.checkFileId(fileId);
        File file = new File(this.rootFolder + "/" + fileId);
        if (file.exists()) {
            try {
                this.inputStream = new FileInputStream(file);
                return this.inputStream;
            }
            catch (Exception var4) {
                throw new RuntimeException(var4);
            }
        }
        this.log.error(fileId + " File does not exist, download failed");
        return null;
    }

    public byte[] downloadFile(String fileId) {
        this.checkFileId(fileId);
        File file = new File(this.rootFolder + "/" + fileId);
        if (file.exists()) {
            byte[] var4;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                var4 = this.fileToByte(fileInputStream, file.length());
            }
            catch (Exception var13) {
                throw new RuntimeException(var13);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException var12) {
                        var12.printStackTrace();
                    }
                }
            }
            return var4;
        }
        this.log.error(fileId + " File does not exist, download failed");
        return null;
    }

    private byte[] fileToByte(InputStream inStream, long fileLength) throws IOException {
        int length;
        byte[] buffer = new byte[262144];
        byte[] fileBuffer = new byte[(int)fileLength];
        int count = 0;
        boolean var7 = false;
        while ((length = inStream.read(buffer)) != -1) {
            for (int i = 0; i < length; ++i) {
                fileBuffer[count + i] = buffer[i];
            }
            count += length;
        }
        return fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void byteToFile(byte[] buf, File file) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception var17) {
            var17.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException var16) {
                    var16.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException var15) {
                    var15.printStackTrace();
                }
            }
        }
    }

    private String generateNewFileName(String fileExtName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String currentTime = df.format(new Date());
        return null != fileExtName && !"".equals(fileExtName) ? currentTime + "-" + UUID.randomUUID().toString().toUpperCase().replace("-", "").substring(0, 8) + "." + fileExtName : currentTime + "-" + UUID.randomUUID().toString().toUpperCase().replace("-", "").substring(0, 8);
    }

    private void checkFileId(String fileId) {
        String upMenu = "../";
        String currentMenu = "./";
        if (fileId.contains(upMenu) || fileId.contains(currentMenu)) {
            throw new RuntimeException("Illegal file id");
        }
    }
}

