/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.admin.validation.ext;

import cn.com.yusys.icsp.admin.service.AdminSmLookupItemCacheService;
import cn.com.yusys.icsp.admin.service.AdminSmLookupItemClient;
import cn.com.yusys.icsp.admin.validation.InDataCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class InDataCodeValidator
implements ConstraintValidator<InDataCode, String> {
    private String dataCode;
    @Autowired
    private AdminSmLookupItemClient adminSmLookupItemClient;
    @Autowired
    AdminSmLookupItemCacheService adminSmLookupItemCacheService;

    public void initialize(InDataCode constraintAnnotation) {
        this.dataCode = constraintAnnotation.dataCode();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value || "".equals(value)) {
            return true;
        }
        List<Object> codes = new ArrayList();
        Map<String, List<Map<String, String>>> LookupCodeMap = this.adminSmLookupItemCacheService.getLookupCodeCacheList(this.dataCode);
        if (LookupCodeMap != null && LookupCodeMap.containsKey(this.dataCode)) {
            List<Map<String, String>> lookupItem = LookupCodeMap.get(this.dataCode);
            if (lookupItem != null && lookupItem.size() > 0) {
                for (Map<String, String> map : lookupItem) {
                    codes.add(map.get("key"));
                }
            }
        } else {
            codes = this.adminSmLookupItemClient.getLookupItemCode(this.dataCode);
        }
        if (codes == null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Query data dictionary exception, please contact the administrator!").addConstraintViolation();
            return false;
        }
        if (codes.size() == 0) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("The data dictionary [dataCode:" + this.dataCode + "] corresponding to this field does not exist!").addConstraintViolation();
            return false;
        }
        return codes.contains(value);
    }
}

