/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.web.rest.errors;

import cn.com.yusys.icsp.commons.exception.IcspException;
import cn.com.yusys.icsp.commons.exception.YuspException;
import cn.com.yusys.icsp.commons.util.StringUtil;
import cn.com.yusys.icsp.commons.web.rest.dto.IcspResultDto;
import cn.com.yusys.icsp.commons.web.rest.dto.ResultDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@ConditionalOnProperty(name={"application.extrans.enabled"}, matchIfMissing=true)
public class ExceptionTranslatorIcsp {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionTranslatorIcsp.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public IcspResultDto handlerMyException(MethodArgumentNotValidException ex) {
        logger.error("MethodArgumentNotValidException  Advice\uff0cMessage:{}", (Object)ex.getMessage(), (Object)ex);
        List errors = ex.getBindingResult().getFieldErrors();
        StringBuilder message = new StringBuilder();
        for (FieldError error : errors) {
            message.append(error.getField() + ":" + error.getDefaultMessage() + "  ");
        }
        return IcspResultDto.failure((String)"503", (String)ex.getMessage());
    }

    @ExceptionHandler(value={ConcurrencyFailureException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public IcspResultDto processConcurrencyError(ConcurrencyFailureException ex) {
        logger.error("ConcurrencyFailureException  Advice\uff0cMessage:{}", (Object)ex.getMessage(), (Object)ex);
        return IcspResultDto.failure((String)"505", (String)ex.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public IcspResultDto processMethodNotSupportedException(HttpRequestMethodNotSupportedException ex) {
        logger.error("HttpRequestMethodNotSupportedException  Advice\uff0cMessage:{}", (Object)ex.getMessage(), (Object)ex);
        return IcspResultDto.failure((String)"504", (String)ex.getMessage());
    }

    @ExceptionHandler(value={YuspException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResultDto processBusiException(YuspException ex) {
        ResultDto dto = StringUtil.isNumeric((CharSequence)ex.getCode()) ? new ResultDto(Integer.parseInt(ex.getCode()), ex.getMsg(), ex.getLevel()) : new ResultDto(Integer.parseInt("500"), "[" + ex.getCode() + "]" + ex.getMsg(), ex.getLevel());
        return dto;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public IcspResultDto processPkError(DuplicateKeyException ex) {
        logger.error("DuplicateKeyException Advice\uff0cMessage:{}", (Object)ex.getMessage(), (Object)ex);
        return IcspResultDto.failure((String)"506", (String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public IcspResultDto processRuntimeException(Exception ex) {
        logger.error("Exception Advice\uff0cCode:{}\uff0cMessage:{}", new Object[]{HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), ex});
        return IcspResultDto.failure((String)"500", (String)ex.getMessage());
    }

    @ExceptionHandler(value={IcspException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public IcspResultDto processIcspException(IcspException ex) {
        String requestSeq = null;
        if (!StringUtil.isEmpty((CharSequence)ex.getRequestSeq())) {
            requestSeq = ex.getRequestSeq();
        }
        logger.error("IcspException Advice\uff0cCode:{}\uff0cMessage:{}", new Object[]{ex.getResponseCode(), ex.getMessage(), ex});
        return IcspResultDto.failure((String)requestSeq, (String)ex.getResponseCode(), (String)ex.getMessage());
    }
}

