/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.web.rest;

import cn.com.yusys.icsp.commons.service.CommonService;
import cn.com.yusys.icsp.commons.web.rest.dto.IcspResultDto;
import cn.com.yusys.icsp.commons.web.rest.req.IcspRequest;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class CommonResource<T, PK extends Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(CommonResource.class);

    @PostMapping(value={"/index"})
    protected IcspResultDto<List<T>> index(@RequestBody IcspRequest<T> request) {
        logger.debug("REST request to query index : {}", (Object)request.getQueryModel());
        List list = this.getCommonService().selectByModel(request.getQueryModel());
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/show"})
    protected IcspResultDto<Object> show(@ApiParam(value="Object of PK id", required=true) @RequestBody IcspRequest<PK> request) {
        logger.debug("REST request to get Object : {}", request.getBody());
        Object Object2 = this.getCommonService().selectByPrimaryKey(request.getBody());
        return IcspResultDto.success((Object)Object2);
    }

    @PostMapping(value={"/create"})
    protected IcspResultDto<T> create(@ApiParam(value="Object", required=true) @RequestBody IcspRequest<T> request) throws URISyntaxException {
        logger.debug("REST request to save Object : {}", request.getBody());
        this.getCommonService().insert(request.getBody());
        return IcspResultDto.success((Object)request.getBody());
    }

    @PostMapping(value={"/update"})
    protected IcspResultDto<Integer> update(@ApiParam(value="Object", required=true) @RequestBody IcspRequest<T> request) throws URISyntaxException {
        logger.debug("REST request to update Object : {}", request.getBody());
        IcspResultDto resultDto = new IcspResultDto();
        try {
            int result = this.getCommonService().update(request.getBody());
            resultDto = IcspResultDto.success((Object)result);
        }
        catch (Exception e) {
            resultDto = IcspResultDto.failure((String)"500", (String)e.getMessage());
        }
        return resultDto;
    }

    @PostMapping(value={"/delete"})
    protected IcspResultDto<Integer> delete(@ApiParam(value="Object Of PK id", required=true) @RequestBody IcspRequest<PK> request) {
        logger.debug("REST request to delete Object : {}", request.getBody());
        IcspResultDto resultDto = new IcspResultDto();
        try {
            int result = this.getCommonService().deleteByPrimaryKey(request.getBody());
            resultDto = IcspResultDto.success((Object)result);
        }
        catch (Exception e) {
            resultDto = IcspResultDto.failure((String)"500", (String)e.getMessage());
        }
        return resultDto;
    }

    @PostMapping(value={"/batchdelete"})
    protected IcspResultDto<Integer> deletes(@ApiParam(value="Object Of PK id", required=true) @RequestBody IcspRequest<PK> request) {
        logger.debug("REST request to delete Object : {}", request.getBody());
        int result = this.getCommonService().deleteByIds(((Serializable)request.getBody()).toString());
        return IcspResultDto.success((Object)result);
    }

    protected abstract CommonService getCommonService();
}

