/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.interceptor;

import cn.com.yusys.icsp.commons.security.SecurityUtils;
import cn.com.yusys.icsp.commons.util.AESUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCopyInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(TokenCopyInterceptor.class);
    private String appName;

    public TokenCopyInterceptor(String serviceName) {
        this.appName = serviceName;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request;
        Request original;
        String accessToken = SecurityUtils.getCurrentUserToken();
        String encryptName = "";
        if (StringUtils.isNotBlank((CharSequence)this.appName)) {
            encryptName = AESUtil.encrypt((String)this.appName, (String)"YUSP");
        }
        if (accessToken != null && !"".equals(accessToken)) {
            logger.info("\u5f00\u59cb\u6ce8\u5165,token[{}].", (Object)accessToken);
            original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().addHeader("Authorization", "Bearer " + SecurityUtils.getCurrentUserToken());
            if (StringUtils.isNotBlank((CharSequence)this.appName)) {
                requestBuilder.addHeader("appName", encryptName);
            }
            request = requestBuilder.build();
        } else {
            logger.info("\u4e0d\u6ce8\u5165,token[{}].", (Object)accessToken);
            original = chain.request();
            Request.Builder requestBuilder = original.newBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.appName)) {
                requestBuilder.addHeader("appName", encryptName);
            }
            request = requestBuilder.build();
        }
        logger.info("\u53d1\u9001\u8bf7\u6c42,url[{}].", (Object)request.url());
        Response response = chain.proceed(request);
        logger.info("\u5b8c\u6210token\u6ce8\u5165,\u54cd\u5e94code[{}]", (Object)response.code());
        return response;
    }
}

