/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.filter;

import cn.com.yusys.icsp.commons.dto.DataContr;
import cn.com.yusys.icsp.commons.dto.User;
import cn.com.yusys.icsp.commons.mapper.interceptor.DataAuthHandler;
import cn.com.yusys.icsp.commons.security.SecurityUtils;
import cn.com.yusys.icsp.commons.service.UserService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class DataAuthFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DataAuthFilter.class);
    public static final String UTF8 = "UTF-8";
    private AntPathMatcher matcher = new AntPathMatcher();
    private UrlPathHelper pathHelper = new UrlPathHelper();
    @Autowired
    private UserService userCacheService;
    @Value(value="${application.web.ignore-urls}")
    private String ignoreUrlStrs = null;
    private List<String> ignoreUrls;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("Create access permission interceptor!");
        if (null == this.ignoreUrlStrs) {
            return;
        }
        this.ignoreUrls = Arrays.asList(this.ignoreUrlStrs.split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestUri = this.pathHelper.getLookupPathForRequest(request);
        if (logger.isDebugEnabled()) {
            logger.debug("DataAuthFilter enter utl:{}", (Object)requestUri);
        }
        boolean result = false;
        if (null != this.ignoreUrls) {
            result = this.ignoreUrls.stream().anyMatch(ctrl -> this.matcher.match(ctrl, requestUri));
        }
        if (!result) {
            String accessToken = SecurityUtils.getCurrentUserToken();
            if (null == accessToken) {
                logger.warn("token[{}]\u4e3a\u7a7a\uff0c\u8bb0\u5f55\u96c6\u6743\u9650\u4e0d\u751f\u6548", (Object)accessToken);
            } else {
                String loginCode = this.userCacheService.getUserCode(accessToken);
                if (logger.isDebugEnabled()) {
                    logger.debug("loginCode:{};token:{}", (Object)loginCode, (Object)accessToken);
                }
                if (null == loginCode) {
                    logger.error("\u7528\u6237[{}]\u6216token[{}]\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\uff0c\u8bb0\u5f55\u96c6\u6743\u9650\u4e0d\u751f\u6548", (Object)loginCode, (Object)accessToken);
                } else {
                    User userInfo = this.userCacheService.getUserInfo(loginCode, null, accessToken);
                    if (userInfo == null) {
                        logger.error("\u7528\u6237[{}]\u4f1a\u8bdd\u4fe1\u606f\u67e5\u8be2\u5931\u8d25,token[{}]\uff0c\uff0c\u8bb0\u5f55\u96c6\u6743\u9650\u4e0d\u751f\u6548", (Object)loginCode, (Object)accessToken);
                    } else {
                        this.addDataAuthInfo(loginCode, null, accessToken, userInfo, requestUri);
                    }
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
        this.cleanDataAuthInfo();
    }

    public void destroy() {
    }

    private void cleanDataAuthInfo() {
        DataAuthHandler.dataAuthTemplate.remove();
        DataAuthHandler.dataAuthParams.remove();
    }

    private void addDataAuthInfo(String loginCode, String sysId, String accessToken, User userInfo, String requestUri) {
        List dataCtrlList = this.userCacheService.getDataAuth(loginCode, sysId, accessToken);
        if (dataCtrlList != null && !dataCtrlList.isEmpty()) {
            List matchDataCtrlList = dataCtrlList.stream().filter(data -> requestUri.equals(data.getContrUrl())).collect(Collectors.toList());
            DataContr matchDataCtrl = null;
            if (matchDataCtrlList == null || matchDataCtrlList.size() == 0) {
                List defaultDataCtrl;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u7528\u6237[{}]\u8bbf\u95ee\u7684\u63a7\u5236\u70b9{}\u4f7f\u7528\u9ed8\u8ba4\u6a21\u677f.", (Object)loginCode, (Object)requestUri);
                }
                if ((defaultDataCtrl = dataCtrlList.stream().filter(data -> "*".equals(data.getContrId())).collect(Collectors.toList())) != null && defaultDataCtrl.size() > 0) {
                    matchDataCtrl = (DataContr)defaultDataCtrl.get(0);
                }
            } else if (matchDataCtrlList.size() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u7528\u6237[{}]\u8bbf\u95ee\u7684\u63a7\u5236\u70b9{}\u4f7f\u7528\u7279\u5b9a\u6a21\u677f,\u7279\u5b9a\u6a21\u677f\u6709[{}]\u6761", new Object[]{loginCode, requestUri, matchDataCtrlList.size()});
                }
                matchDataCtrl = matchDataCtrlList.stream().min(Comparator.comparing(DataContr::getPriority)).orElseGet(() -> {
                    logger.warn("\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                    return null;
                });
            }
            if (matchDataCtrl != null) {
                String dataAuthTemplate = matchDataCtrl.getSqlString();
                logger.info("\u6570\u636e\u6743\u9650\u6a21\u677f:{};\u6570\u636e\u6743\u9650\u53c2\u6570:{}", (Object)dataAuthTemplate, (Object)userInfo);
                DataAuthHandler.dataAuthTemplate.set(dataAuthTemplate);
                DataAuthHandler.dataAuthParams.set(this.getAuthParams(userInfo));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("\u7528\u6237[{}]\u89d2\u8272\u4e0b\u6ca1\u6709\u6570\u636e\u6743\u9650\u6a21\u677f", (Object)loginCode);
        }
    }

    private Map<String, Object> getAuthParams(User userInfo) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            dataMap.put("_userCode", userInfo.getLoginCode());
            dataMap.put("_orgCode", userInfo.getOwnOrg().getOrgCode());
            if (userInfo.getOwnOrg() != null) {
                dataMap.put("_ownOrgCode", userInfo.getOwnOrg().getOrgCode());
                dataMap.put("_ownCheckOrgId", userInfo.getOwnOrg().getCheckOrgId());
                dataMap.put("_ownUpOrgId", userInfo.getOwnOrg().getUpOrgId());
                dataMap.put("_ownOrgType", userInfo.getOwnOrg().getOrgType());
                dataMap.put("_ownBranchCode", userInfo.getOwnOrg().getBranchCode());
            }
            if (userInfo.getCurrentOrg() != null) {
                dataMap.put("_currentOrgCode", userInfo.getCurrentOrg().getOrgCode());
                dataMap.put("_currentCheckOrgId", userInfo.getCurrentOrg().getCheckOrgId());
                dataMap.put("_currentUpOrgId", userInfo.getCurrentOrg().getUpOrgId());
                dataMap.put("_currentOrgType", userInfo.getCurrentOrg().getOrgType());
                dataMap.put("_currentBranchCode", userInfo.getCurrentOrg().getBranchCode());
            }
            logger.debug("\u7528\u6237[{}]\u4f7f\u7528\u6570\u636e\u6a21\u677f\u53c2\u6570\u4e3a: {}", (Object)userInfo.getLoginCode(), dataMap);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u6743\u9650\u6a21\u677f\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        return dataMap;
    }
}

