/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.config;

import cn.com.yusys.icsp.commons.config.ApplicationProperties;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ConditionalOnClass(value={ApiInfo.class})
@EnableSwagger2
@ConditionalOnProperty(name={"application.swagger.enabled"}, havingValue="true")
public class SwaggerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    private static final Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();

    @Bean
    public Docket swaggerSpringfoxDocket(ApplicationProperties applicationProperties) {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting Swagger");
        }
        StopWatch watch = new StopWatch();
        watch.start();
        Contact contact = new Contact(applicationProperties.getSwagger().getContactName(), applicationProperties.getSwagger().getContactUrl(), applicationProperties.getSwagger().getContactEmail());
        ApiInfo apiInfo = new ApiInfo(applicationProperties.getSwagger().getTitle(), applicationProperties.getSwagger().getDescription(), applicationProperties.getSwagger().getVersion(), applicationProperties.getSwagger().getTermsOfServiceUrl(), contact, applicationProperties.getSwagger().getLicense(), applicationProperties.getSwagger().getLicenseUrl());
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).forCodeGeneration(true).directModelSubstitute(ByteBuffer.class, String.class).genericModelSubstitutes(new Class[]{ResponseEntity.class}).select().apis(RequestHandlerSelectors.any()).paths(this.regex(applicationProperties.getSwagger().getDefaultIncludePattern())).build();
        watch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("Started Swagger in {} ms", (Object)watch.getTotalTimeMillis());
        }
        return docket;
    }

    public Predicate<String> regex(String pathPattern) {
        return input -> (Boolean)Optional.fromNullable((Object)input).transform(SwaggerAutoConfiguration.handlerPackage(pathPattern)).or((Object)true);
    }

    private static Function<String, Boolean> handlerPackage(String pathPattern) {
        return input -> splitter.splitToList((CharSequence)pathPattern).parallelStream().anyMatch(input::matches);
    }
}

