/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.config;

import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=-2147483647)
public class DefaultEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spring.jackson.serialization.INDENT_OUTPUT", true);
        map.put("management.endpoints.enabled-by-default", true);
        map.put("management.endpoints.web.exposure.include", "*");
        map.put("management.endpoint.health.show-details", "always");
        map.put("management.health.mail.enabled", false);
        map.put("eureka.instance.prefer-ip-address", true);
        map.put("eureka.instance.instance-id", "${spring.cloud.client.ip-address}:${spring.application.name}:${server.port}");
        map.put("feign.okhttp.enabled", true);
        map.put("mybatis.configuration.map-underscore-to-camel-case", true);
        map.put("mybatis.configuration.jdbc-type-for-null", "'null'");
        map.put("mapper.mappers", "cn.com.yusys.icsp.commons.mapper.CommonMapper");
        map.put("spring.mvc.favicon.enabled", false);
        MapPropertySource target = (MapPropertySource)environment.getPropertySources().get(PROPERTY_SOURCE_NAME);
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        environment.getPropertySources().addLast((PropertySource)target);
    }
}

