/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.config;

import cn.com.yusys.icsp.commons.service.UserService;
import cn.com.yusys.icsp.commons.service.impl.UserServiceCacheImpl;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@EnableCaching
@ConditionalOnClass(value={RedisConnectionFactory.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cache.type"}, havingValue="redis")
public class CacheAutoConfiguration {
    @Value(value="${application.cache.ttl:720}")
    private int ttl;
    private static final Logger logger = LoggerFactory.getLogger(CacheAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"application.cache.user.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={UserService.class})
    public UserService userCacheService() {
        logger.info("Query user information, load UserCacheServiceCacheImpl, base on cache");
        return new UserServiceCacheImpl();
    }

    @Bean
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public CacheManager cacheManager(RedisConnectionFactory factory) {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        RedisCacheConfiguration cacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer)).entryTtl(Duration.ofMinutes(this.ttl));
        logger.info("Auto configuration >> cache serialize configuration completed");
        return RedisCacheManager.builder((RedisConnectionFactory)factory).cacheDefaults(cacheConfiguration).build();
    }

    @Component
    public class RedisHelper {
        @Autowired
        private StringRedisTemplate stringRedisTemplate;

        public void scan(String pattern, Consumer<byte[]> consumer) {
            this.stringRedisTemplate.execute(connection -> {
                try {
                    Object var5;
                    try (Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());){
                        cursor.forEachRemaining(consumer);
                        var5 = null;
                    }
                    return var5;
                }
                catch (IOException var17) {
                    logger.error("Redis Scan keys[{}] occured error,errorMsg:{} ", (Object)pattern, (Object)var17.getMessage());
                    throw new RuntimeException(var17);
                }
            });
        }

        public List<String> keys(String pattern) {
            ArrayList<String> keys = new ArrayList<String>();
            this.scan(pattern, item -> {
                String key = new String((byte[])item, StandardCharsets.UTF_8);
                keys.add(key);
            });
            return keys;
        }
    }
}

