/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.log.common.appender;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import cn.com.yusys.icsp.commons.log.common.util.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.LoggerFactory;

public class JsonAppender
extends RollingFileAppender<ILoggingEvent> {
    private static Logger logger = (Logger)LoggerFactory.getLogger(JsonAppender.class);
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private long freq = 10L;
    private int cacheCapacity = 128;
    private String ignoreCommonFields;
    private boolean noCommonFields = false;
    private String finalFieldsStr = "";
    private boolean ignoreTime = false;
    private Lock cacheLock = new ReentrantLock(false);
    private List<String> logCache;
    private ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private String serviceName;
    private String port = "8080";
    private static String ip;

    public void start() {
        this.processCommonFields();
        if (this.logCache == null) {
            this.logCache = new ArrayList<String>(this.cacheCapacity);
        }
        this.scheduledExecutor.scheduleAtFixedRate(() -> {
            this.cacheLock.lock();
            List<String> cache = this.logCache;
            this.logCache = new ArrayList<String>(this.cacheCapacity);
            this.cacheLock.unlock();
            this.writeLog(cache);
        }, this.freq, this.freq, TimeUnit.SECONDS);
        super.start();
    }

    private void processCommonFields() {
        if (!this.noCommonFields) {
            LinkedHashMap<String, String> finalFields = new LinkedHashMap<String, String>();
            finalFields.put("serviceName", this.serviceName);
            finalFields.put("ip", ip);
            finalFields.put("port", this.port);
            if (StringUtil.isEmpty(this.ignoreCommonFields)) {
                this.genFinalFieldsStr(finalFields);
            } else {
                String[] ignores;
                String[] var3 = ignores = this.ignoreCommonFields.split(",");
                int var4 = ignores.length;
                for (int var5 = 0; var5 < var4; ++var5) {
                    String str = var3[var5];
                    if ("logTimestamp".equals(str)) {
                        this.ignoreTime = true;
                    }
                    finalFields.remove(str);
                }
                if (finalFields.isEmpty()) {
                    this.noCommonFields = true;
                } else {
                    this.genFinalFieldsStr(finalFields);
                }
            }
        }
    }

    private void genFinalFieldsStr(Map<String, String> finalFields) {
        for (Map.Entry<String, String> entry : finalFields.entrySet()) {
            this.finalFieldsStr = String.format("%s\"%s\":\"%s\",", this.finalFieldsStr, entry.getKey(), entry.getValue());
        }
    }

    protected void subAppend(ILoggingEvent event) {
        if (event != null && !StringUtil.isEmpty(event.getFormattedMessage())) {
            this.cacheLock.lock();
            if (this.logCache.size() > this.cacheCapacity - 1) {
                List<String> cache = this.logCache;
                this.logCache = new ArrayList<String>(this.cacheCapacity);
                this.addCache(event.getFormattedMessage());
                this.cacheLock.unlock();
                this.writeLog(cache);
            } else {
                this.addCache(event.getFormattedMessage());
                this.cacheLock.unlock();
            }
        }
    }

    private void addCache(String msg) {
        if (this.noCommonFields) {
            this.logCache.add(msg);
        } else if ((msg = msg.trim()).startsWith("{") && msg.endsWith("}")) {
            this.logCache.add(this.genJsonMsg(msg));
        }
    }

    private String genJsonMsg(String msg) {
        return this.ignoreTime ? "{" + this.finalFieldsStr + msg.substring(1) : "{" + this.finalFieldsStr + "\"logTimestamp\":\"" + this.getCurrentTime() + "\"," + msg.substring(1);
    }

    private void writeLog(List<String> cache) {
        if (!cache.isEmpty()) {
            String allCacheMsg = String.join((CharSequence)"\n", cache);
            LoggingEvent loggingEvent = new LoggingEvent("ch.qos.logback.classic.Logger", logger, Level.INFO, allCacheMsg, (Throwable)null, (Object[])null);
            super.subAppend((Object)loggingEvent);
        }
    }

    private String getCurrentTime() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(LOG_TIMESTAMP_FORMAT);
        return dtf.format(LocalDateTime.now());
    }

    public long getFreq() {
        return this.freq;
    }

    public void setFreq(long freq) {
        this.freq = freq;
    }

    public int getCacheCapacity() {
        return this.cacheCapacity;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIgnoreCommonFields() {
        return this.ignoreCommonFields;
    }

    public void setIgnoreCommonFields(String ignoreCommonFields) {
        this.ignoreCommonFields = ignoreCommonFields;
    }

    public boolean isNoCommonFields() {
        return this.noCommonFields;
    }

    public void setNoCommonFields(boolean noCommonFields) {
        this.noCommonFields = noCommonFields;
    }

    static {
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException var1) {
            logger.warn("", (Throwable)var1);
        }
    }
}

