/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.log.trace.collect;

import cn.com.yusys.icsp.commons.log.trace.TraceLogger;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.Encoding;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;

public class TraceLoggerSender
extends Sender {
    private final Logger log = LoggerFactory.getLogger(TraceLoggerSender.class);
    @Value(value="${application.log.trace.enable:true}")
    private Boolean isSwitch;
    private Encoding encoding;
    private BytesMessageEncoder messageEncoder;
    transient boolean closeCalled;

    public TraceLoggerSender(RestTemplate restTemplate, String baseUrl, BytesEncoder<Span> encoder) {
        this.log.info("\u5f00\u59cb\u6267\u884c\uff1aTraceLogRestTemplateSender \u6784\u9020\u51fd\u6570 ");
        this.encoding = encoder.encoding();
        this.messageEncoder = BytesMessageEncoder.forEncoding((Encoding)this.encoding);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> spans) {
        return this.encoding().listSizeInBytes(spans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("close");
        }
        return new HttpPostCall(this.messageEncoder.encode(encodedSpans));
    }

    public CheckResult check() {
        try {
            this.log.debug("\u5f00\u59cb\u6267\u884c\uff1acheck ");
            this.post(new byte[]{91, 93});
            return CheckResult.OK;
        }
        catch (Exception var2) {
            return CheckResult.failed((Throwable)var2);
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    void post(byte[] json) {
        this.collectTraceFormatLog(json);
    }

    public void collectTraceLog(byte[] json) {
        this.log.info("\u6570\u636e\u4e0d\u89e3\u6790\u8f93\u51fa!");
        long startTime = System.nanoTime();
        if (this.isSwitch.booleanValue() && json.length > 0) {
            try {
                JSONArray arrays = JSON.parseArray((String)new String(json, "UTF-8"));
                if (!CollectionUtils.isEmpty((Collection)arrays)) {
                    for (Object str : arrays) {
                        TraceLogger.info(str);
                    }
                } else {
                    this.log.info("application.log.trace.enable = " + this.isSwitch + ",can not output trace info to log file!");
                }
            }
            catch (UnsupportedEncodingException var7) {
                this.log.error(var7.getMessage(), (Throwable)var7);
            }
        }
        long endTime = System.nanoTime();
        this.log.info("\u6570\u636e\u4e0d\u89e3\u6790\u8fd0\u884c\u65f6\u95f4\uff1a " + (endTime - startTime) + "ns");
    }

    public void collectTraceFormatLog(byte[] json) {
        block10: {
            if (this.isSwitch.booleanValue() && json.length > 0) {
                try {
                    JSONArray arrays = JSON.parseArray((String)new String(json, "UTF-8"));
                    if (CollectionUtils.isEmpty((Collection)arrays)) break block10;
                    for (Object str : arrays) {
                        try {
                            Object obj;
                            JSONObject objJson = JSON.parseObject((String)String.valueOf(str));
                            Long timestamp = (Long)objJson.get((Object)"timestamp");
                            if (timestamp != null) {
                                try {
                                    long timestampMillis = Long.valueOf(String.valueOf(timestamp).substring(0, 13));
                                    objJson.put("timestampMillis", (Object)timestampMillis);
                                }
                                catch (NumberFormatException var9) {
                                    this.log.error("NumberFormatException", (Throwable)var9);
                                }
                            }
                            if ((obj = objJson.get((Object)"tags")) != null) {
                                objJson.put("tags", (Object)JSON.toJSONString((Object)obj));
                            }
                            TraceLogger.info(objJson);
                        }
                        catch (Exception var10) {
                            this.log.error("conver trace String to json error", (Throwable)var10);
                        }
                    }
                }
                catch (UnsupportedEncodingException var11) {
                    this.log.error("collectTraceFormatLog method error", (Throwable)var11);
                }
            }
        }
    }

    class HttpPostCall
    extends Call.Base<Void> {
        private final byte[] message;

        HttpPostCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            TraceLoggerSender.this.post(this.message);
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                TraceLoggerSender.this.post(this.message);
                callback.onSuccess(null);
            }
            catch (Error | RuntimeException var3) {
                callback.onError(var3);
            }
        }

        public Call<Void> clone() {
            TraceLoggerSender.this.log.info("\u53d1\u9001\u4fe1\u606f\u4e3a\uff1a" + this.message);
            TraceLoggerSender traceLoggerSender = TraceLoggerSender.this;
            ((Object)((Object)traceLoggerSender)).getClass();
            return traceLoggerSender.new HttpPostCall(this.message);
        }
    }
}

