/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.util.Base64Utils;

public class RSAUtils {
    private static final String SHA1WITH_RSA = "SHA1withRSA";
    public static final String ENCODING = "UTF-8";
    public static final String ANDROID = "android";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    public static final String PUBLIC_KEY_VALUE = "publicEncoded";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    public static final String PRIVATE_KEY_VALUE = "privateEncoded";
    private static final int MAX_ENCRYPT_BLOCK = 116;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final Provider provider = new BouncyCastleProvider();

    public static Map<String, Object> genKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        keyMap.put(PUBLIC_KEY_VALUE, Base64.encodeBase64((byte[])publicKey.getEncoded()));
        keyMap.put(PRIVATE_KEY_VALUE, Base64.encodeBase64((byte[])privateKey.getEncoded()));
        return keyMap;
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateK);
        signature.update(data);
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicK);
        signature.update(data);
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = Base64Utils.decodeFromString((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicK);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey, String deviceType) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = null;
        cipher = deviceType.toLowerCase().equals(ANDROID) ? Cipher.getInstance("RSA/ECB/NoPadding") : Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 116 ? cipher.doFinal(data, offSet, 116) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 116;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 116 ? cipher.doFinal(data, offSet, 116) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 116;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public static byte[] decryptByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM, provider);
            cipher.init(2, privateKey);
            byte[] encodedByteArray = new byte[]{};
            for (int i = 0; i < data.length; i += 128) {
                byte[] doFinal = cipher.doFinal(ArrayUtils.subarray((byte[])data, (int)i, (int)(i + 128)));
                encodedByteArray = ArrayUtils.addAll((byte[])encodedByteArray, (byte[])doFinal);
            }
            return encodedByteArray;
        }
        catch (Exception e) {
            throw new Exception("Private key decryption failed, please check", e);
        }
    }

    public static byte[] decryptByPublicKey(byte[] data, PublicKey publicKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM, provider);
            cipher.init(2, publicKey);
            byte[] encodedByteArray = new byte[]{};
            for (int i = 0; i < data.length; i += 128) {
                byte[] doFinal = cipher.doFinal(ArrayUtils.subarray((byte[])data, (int)i, (int)(i + 128)));
                encodedByteArray = ArrayUtils.addAll((byte[])encodedByteArray, (byte[])doFinal);
            }
            return encodedByteArray;
        }
        catch (Exception e) {
            throw new Exception("Public key decryption failed, please check", e);
        }
    }

    public static byte[] encryptByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM, provider);
            cipher.init(1, privateKey);
            byte[] encodedByteArray = new byte[]{};
            for (int i = 0; i < data.length; i += 100) {
                byte[] doFinal = cipher.doFinal(ArrayUtils.subarray((byte[])data, (int)i, (int)(i + 100)));
                encodedByteArray = ArrayUtils.addAll((byte[])encodedByteArray, (byte[])doFinal);
            }
            return encodedByteArray;
        }
        catch (Exception e) {
            throw new Exception("Private key encryption failed, please check", e);
        }
    }

    public static byte[] signByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        try {
            Signature signature = Signature.getInstance(SHA1WITH_RSA, provider);
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new Exception("Failed to add signature, please check", e);
        }
    }

    public static boolean verifyByPublicKey(byte[] data, byte[] signedData, PublicKey publicKey) throws Exception {
        try {
            Signature signature = Signature.getInstance(SHA1WITH_RSA, provider);
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(signedData);
        }
        catch (Exception e) {
            throw new Exception("Failed to verify signature, please check", e);
        }
    }
}

