/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.server.MimeMappings;

public class MimeMappingUtils {
    private static Logger logger = LoggerFactory.getLogger(MimeMappingUtils.class);
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private static MimeMappings mimeMappings = new MimeMappings();

    public static String getMimeType(String suffix) {
        String mimeType = mimeMappings.get(suffix = MimeMappingUtils.getFileSuffixName(suffix));
        if (!StringUtils.isEmpty((CharSequence)mimeType) || !StringUtils.isEmpty((CharSequence)(mimeType = MimeMappings.DEFAULT.get(suffix)))) {
            return mimeType;
        }
        logger.warn("The type [{}] of the file failed to match, which is not supported.", (Object)suffix);
        return DEFAULT_MIME_TYPE;
    }

    public static void add(String extension, String mimeType) {
        mimeMappings.add(extension, mimeType);
    }

    public static Object remove(String extension) {
        return mimeMappings.remove(extension);
    }

    public static String getFileSuffixName(String filename) {
        if (filename != null && filename.length() > 0) {
            int i = filename.lastIndexOf(46);
            if (i > -1 && i < filename.length()) {
                int j;
                String extFileType = filename.substring(i + 1, filename.length());
                if (extFileType != null && extFileType.length() > 0 && (j = extFileType.lastIndexOf(63)) > -1) {
                    return extFileType.substring(0, j);
                }
                return extFileType;
            }
            return filename;
        }
        return "";
    }

    public static String getEncodeFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent").toLowerCase();
        if (userAgent.contains("msie") || userAgent.contains("trident/7.0") || userAgent.contains("edge")) {
            return URLEncoder.encode(filename, "UTF-8");
        }
        if (userAgent.contains("mozilla") || userAgent.contains("chrome")) {
            return new String(filename.getBytes(), "ISO-8859-1");
        }
        return URLEncoder.encode(filename, "UTF-8");
    }

    static {
        mimeMappings.add("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimeMappings.add("xls", "application/vnd.ms-excel");
    }
}

