/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import org.slf4j.helpers.MessageFormatter;

public class LogUtil {
    public static String LOGPOINT_ENTRY = "ENTRY";
    public static String LOGPOINT_EXT = "EXT";
    public static String LOGPOINT_START_CALL = "START_CALL";
    public static String LOGPOINT_END_CALL = "END_CALL";
    public static String LOGPOINT_ON_ERROR = "ON_ERROR";
    public static String LOGPOINT_OTHER = "OTHER";
    private String logPoint;
    private String sourceSys;
    private String tranCode;
    private String destTxcode;
    private Long startTime;

    public LogUtil(String destTxcode) {
        this.destTxcode = destTxcode;
    }

    public LogUtil(String sourceSys, String tranCode, String destTxcode) {
        this.sourceSys = sourceSys;
        this.tranCode = tranCode;
        this.destTxcode = destTxcode;
    }

    public String remoteStartLog(String eventInfo) {
        this.startTime = System.currentTimeMillis();
        Object[] objects = new String[]{LOGPOINT_START_CALL, this.destTxcode, eventInfo};
        return MessageFormatter.arrayFormat((String)"[LOG_POINT={} DEST_TXCODE={} EVENT_INFO={} ]", (Object[])objects).getMessage();
    }

    public String remoteEndLog(String eventInfo) {
        long duration = System.currentTimeMillis() - this.startTime;
        Object[] objects = new String[]{LOGPOINT_END_CALL, this.destTxcode, String.valueOf(duration), eventInfo};
        return MessageFormatter.arrayFormat((String)"[LOG_POINT={} DEST_TXCODE={} DURATION={} EVENT_INFO={}]", (Object[])objects).getMessage();
    }

    public String localStartLog(String eventInfo) {
        this.startTime = System.currentTimeMillis();
        Object[] objects = new String[]{LOGPOINT_ENTRY, this.sourceSys, this.tranCode, eventInfo};
        return MessageFormatter.arrayFormat((String)"[LOG_POINT={} SOURCE_SYSY={} TRAN_CODE={} EVENT_INFO={}]", (Object[])objects).getMessage();
    }

    public String localEndtLog(String eventInfo) {
        long duration = System.currentTimeMillis() - this.startTime;
        Object[] objects = new String[]{LOGPOINT_EXT, this.sourceSys, this.tranCode, String.valueOf(duration), eventInfo};
        return MessageFormatter.arrayFormat((String)"[LOG_POINT={} SOURCE_SYSY={} TRAN_CODE={} DURATION={} EVENT_INFO={}]", (Object[])objects).getMessage();
    }

    public String expLog(String eventInfo) {
        Object[] objects = new String[]{LOGPOINT_ON_ERROR, this.sourceSys, this.tranCode, eventInfo};
        return MessageFormatter.arrayFormat((String)"[LOG_POINT={} SOURCE_SYSY={} TRAN_CODE={} EVENT_INFO={}]", (Object[])objects).getMessage();
    }

    public String log(String eventInfo) {
        Object[] objects = new String[]{LOGPOINT_OTHER, this.tranCode, eventInfo};
        return MessageFormatter.arrayFormat((String)"[LOG_POINT={} TRAN_CODE={} EVENT_INFO={}]", (Object[])objects).getMessage();
    }

    public String getLogPoint() {
        return this.logPoint;
    }

    public void setLogPoint(String logPoint) {
        this.logPoint = logPoint;
    }

    public String getSourceSys() {
        return this.sourceSys;
    }

    public void setSourceSys(String sourceSys) {
        this.sourceSys = sourceSys;
    }

    public String getTranCode() {
        return this.tranCode;
    }

    public void setTranCode(String tranCode) {
        this.tranCode = tranCode;
    }

    public String getDestTxcode() {
        return this.destTxcode;
    }

    public void setDestTxcode(String destTxcode) {
        this.destTxcode = destTxcode;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }
}

