/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class KeyStoreUtil {
    private static final String CERT_TYPE = "X.509";

    public static PrivateKey getPrivateKeyFromJks(String path, String keyStorePwd, String keyPwd, String alias) throws Exception {
        try (FileInputStream jksInputStream = null;){
            PrivateKey privateKey;
            KeyStore keyStore = KeyStore.getInstance("jks");
            jksInputStream = new FileInputStream(new File(path));
            keyStore.load(jksInputStream, keyStorePwd.toCharArray());
            PrivateKey privateKey2 = privateKey = (PrivateKey)keyStore.getKey(alias, keyPwd.toCharArray());
            return privateKey2;
        }
    }

    public static X509Certificate getX509CertificateFromJks(String path, String keyStorePwd, String alias) throws Exception {
        try (FileInputStream jksInputStream = null;){
            KeyStore keyStore = KeyStore.getInstance("jks");
            jksInputStream = new FileInputStream(new File(path));
            keyStore.load(jksInputStream, keyStorePwd.toCharArray());
            Certificate certificate = keyStore.getCertificate(alias);
            X509Certificate x509Certificate = (X509Certificate)certificate;
            return x509Certificate;
        }
    }

    public static PublicKey getPublicKeyFromCert(String path) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE, (Provider)new BouncyCastleProvider());
        FileInputStream certInputStream = new FileInputStream(path);
        Certificate certificate = certificateFactory.generateCertificate(certInputStream);
        certInputStream.close();
        return certificate.getPublicKey();
    }

    public static KeyStore loadKeyStoreFromJksPath(String jksPath, String alias, String storeType, String passWord) throws Exception {
        char[] pw = passWord.toCharArray();
        storeType = null == storeType ? KeyStore.getDefaultType() : storeType;
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream is = new FileInputStream(jksPath);){
            keyStore.load(is, pw);
        }
        return keyStore;
    }

    public static PrivateKey getPrivateKeyFromStore(String jksPath, String alias, String storeType, String passWord) throws Exception {
        KeyStore keyStore = KeyStoreUtil.loadKeyStoreFromJksPath(jksPath, alias, storeType, passWord);
        return (PrivateKey)keyStore.getKey(alias, passWord.toCharArray());
    }

    public static PublicKey getPublicKeyFromStore(String jksPath, String alias, String storeType, String passWord) throws Exception {
        KeyStore keyStore = KeyStoreUtil.loadKeyStoreFromJksPath(jksPath, alias, storeType, passWord);
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
        return x509Certificate.getPublicKey();
    }
}

