/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.concurrent.ThreadLocalRandom;

public class IdUtil {
    private static final SnowflakeIdGenerator idWorker;
    private static String randomString;

    public static final String getId() {
        Long idValue = idWorker.nextId();
        String id = Long.toString(idValue);
        StringBuffer sb = new StringBuffer();
        if (id.startsWith("-")) {
            sb.append("Z").append(randomString).append(id.substring(1));
        } else {
            sb.append("A").append(randomString).append(id);
        }
        return sb.toString();
    }

    public static final String getNumberId() {
        Long idValue = idWorker.nextId();
        String id = Long.toString(idValue);
        StringBuffer sb = new StringBuffer();
        if (id.startsWith("-")) {
            sb.append("9").append(randomString).append(id.substring(1));
        } else {
            sb.append("1").append(randomString).append(id);
        }
        return sb.toString();
    }

    private static long ipToLong(String strIp) {
        String[] ip = strIp.split("\\.");
        return (Long.parseLong(ip[0]) << 24) + (Long.parseLong(ip[1]) << 16) + (Long.parseLong(ip[2]) << 8) + Long.parseLong(ip[3]);
    }

    protected static String longToIP(long longIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }

    private static String getLocalMac() throws Exception {
        return IdUtil.getLocalMac(InetAddress.getLocalHost());
    }

    private static String getLocalMac(InetAddress ia) throws Exception {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mac.length; ++i) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
                continue;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    static {
        String ip;
        idWorker = new SnowflakeIdGenerator(0L, 0L);
        randomString = "";
        long macAddress = 0L;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
            macAddress = Long.parseLong(IdUtil.getLocalMac().replace("-", ""), 16) % 31L;
        }
        catch (Exception e) {
            ip = "127.0.0.1";
        }
        long randomValue = IdUtil.ipToLong(ip);
        int randomNum = ThreadLocalRandom.current().nextInt(1000);
        randomValue = (long)randomNum + randomValue;
        randomValue += macAddress;
        randomString = String.valueOf(randomValue += (long)ThreadLocalRandom.current().nextInt(1000));
    }

    static class SnowflakeIdGenerator {
        private final long startTime = 1546272000000L;
        private final long workerIdBits = 5L;
        private final long dataCenterIdBits = 5L;
        private final long maxWorkerId = 31L;
        private final long maxDataCenterId = 31L;
        private final long sequenceBits = 12L;
        private final long workerIdMoveBits = 12L;
        private final long dataCenterIdMoveBits = 17L;
        private final long timestampMoveBits = 22L;
        private final long sequenceMask = 4095L;
        private long workerId;
        private long dataCenterId;
        private long sequence = 0L;
        private long lastTimestamp = -1L;

        public SnowflakeIdGenerator(long workerId, long dataCenterId) {
            if (workerId > 31L || workerId < 0L) {
                throw new IllegalArgumentException(String.format("Worker Id can't be greater than %d or less than 0", 31L));
            }
            if (dataCenterId > 31L || dataCenterId < 0L) {
                throw new IllegalArgumentException(String.format("DataCenter Id can't be greater than %d or less than 0", 31L));
            }
            this.workerId = workerId;
            this.dataCenterId = dataCenterId;
        }

        public synchronized long nextId() {
            long timestamp = this.currentTime();
            if (timestamp < this.lastTimestamp) {
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.blockTillNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - 1546272000000L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
        }

        protected long blockTillNextMillis(long lastTimestamp) {
            long timestamp = this.currentTime();
            while (timestamp <= lastTimestamp) {
                timestamp = this.currentTime();
            }
            return timestamp;
        }

        protected long currentTime() {
            return System.currentTimeMillis();
        }
    }
}

