/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import cn.com.yusys.icsp.commons.util.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class FileUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtil.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static long copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static File openFileDir(String dirPath) throws IOException {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            if (!dirFile.mkdirs() && !dirFile.isDirectory()) {
                throw new IOException("Directory '" + dirFile + "' could not be created");
            }
        } else if (!dirFile.isDirectory()) {
            throw new IOException("File '" + dirFile + "' exists but is not a directory");
        }
        return dirFile;
    }

    public static final String readAll(String filePath) throws IOException {
        return FileUtil.readAll(filePath, StandardCharsets.UTF_8.name());
    }

    public static final String readAll(String filePath, String charsetName) throws IOException {
        return FileUtil.readAllLines(filePath, charsetName).stream().reduce("", String::concat);
    }

    public static final List<String> readAllLines(String filePath) throws IOException {
        return FileUtil.readAllLines(filePath, StandardCharsets.UTF_8.name());
    }

    public static final List<String> readAllLines(String filePath, String charsetName) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]) && path.toFile().length() > 0L) {
            return Files.readAllLines(path, Charset.forName(charsetName));
        }
        return new ArrayList<String>();
    }

    public static final void createFile(String filePath) throws IOException {
        FileUtil.createFile(Paths.get(filePath, new String[0]));
    }

    public static final void createFile(Path path) throws IOException {
        if (Objects.isNull(path)) {
            throw new IOException("Failed to create file, current Path is empty!");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Failed to create file, current path:" + path.toString() + "is a folder!!");
        }
        Files.deleteIfExists(path);
        path.toFile().getParentFile().mkdirs();
        Files.createFile(path, new FileAttribute[0]);
    }

    public static final void fileCopy(String srcFilePath, String targetFilePath) throws IOException {
        Files.copy(Paths.get(srcFilePath, new String[0]), Paths.get(targetFilePath, new String[0]), new CopyOption[0]);
    }

    public static final void fileCoverCopy(String srcFilePath, String targetFilePath) throws IOException {
        Path targetPath = Paths.get(targetFilePath, new String[0]);
        Files.deleteIfExists(targetPath);
        Files.copy(Paths.get(srcFilePath, new String[0]), targetPath, new CopyOption[0]);
    }

    public static final String byte2File(byte[] bytes, String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (FileUtil.isFile(filePath)) {
            FileUtil.createFile(path);
            Files.write(path, bytes, new OpenOption[0]);
        }
        return path.toAbsolutePath().toString();
    }

    public static final String byte2File(byte[] bytes, String filePath, String charset) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (FileUtil.isFile(filePath)) {
            FileUtil.createFile(path);
            try (BufferedWriter bw = Files.newBufferedWriter(path, Charset.forName(charset), new OpenOption[0]);){
                bw.write(new String(bytes, charset));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path.toAbsolutePath().toString();
    }

    public static final boolean isFile(String filePath) {
        return !FileUtil.isDirectory(filePath);
    }

    public static final boolean isDirectory(String filePath) {
        return Files.isDirectory(Paths.get(filePath, new String[0]), new LinkOption[0]);
    }

    public static final String write(Collection<String> lineTexts, String filePath, String charset) throws IOException {
        return FileUtil.write(lineTexts, filePath, charset, false);
    }

    public static final String write(Collection<String> lineTexts, String filePath, String charset, boolean isAppend) throws IOException {
        if (StringUtil.isEmpty(charset)) {
            charset = Charset.defaultCharset().name();
        }
        Path path = Paths.get(filePath, new String[0]);
        if (FileUtil.isFile(filePath)) {
            if (!Files.exists(path, new LinkOption[0])) {
                FileUtil.createFile(path.toAbsolutePath().toString());
            }
            OpenOption[] openOptions = null;
            openOptions = isAppend ? new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.SYNC} : new OpenOption[]{};
            Files.write(path, lineTexts, Charset.forName(charset), openOptions);
        }
        return path.toAbsolutePath().toString();
    }
}

