/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.util;

import cn.com.yusys.icsp.commons.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CompressUtil {
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressData(byte[] bytes) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(bytes);
        compressor.finish();
        byte[] buf = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);){
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                bos.write(buf, 0, count);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deCompressData(byte[] bytes) throws DataFormatException, IOException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(bytes);
        byte[] buf = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);){
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static boolean isJarFile(File file) throws IOException {
        boolean manifest;
        if (!CompressUtil.isZipFile(file)) {
            return false;
        }
        try (ZipFile zip = new ZipFile(file);){
            manifest = zip.getEntry(MANIFEST_MF) != null;
        }
        return manifest;
    }

    public static boolean isZipFile(File file) throws IOException {
        int head;
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        try (FilterInputStream in = null;){
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            head = ((DataInputStream)in).readInt();
        }
        return head == 1347093252;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressJar(String pathName, String jarName, boolean isRoot) throws Exception {
        FileOutputStream fos = null;
        try (ZipOutputStream out = null;){
            fos = FileUtil.openOutputStream(new File(jarName));
            out = new JarOutputStream(fos);
            CompressUtil.compressOfManifest((JarOutputStream)out);
            File file = new File(pathName);
            String root = isRoot ? file.getName() + "/" : "";
            CompressUtil.jarDir((JarOutputStream)out, file, root);
        }
    }

    private static void jarDir(JarOutputStream out, File file, String root) throws IOException {
        JarEntry jarEntry = new JarEntry(root);
        out.putNextEntry(jarEntry);
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String tmpRoot = root;
            if (files[i].isDirectory()) {
                tmpRoot = tmpRoot + files[i].getName() + "/";
                CompressUtil.jarDir(out, files[i], tmpRoot);
                continue;
            }
            CompressUtil.jarFile(out, files[i], tmpRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jarFile(JarOutputStream out, File file, String root) throws IOException {
        JarEntry jarEntry = new JarEntry(root + "/" + file.getName());
        out.putNextEntry(jarEntry);
        try (FileInputStream is = new FileInputStream(file);){
            FileUtil.copyStream(is, out);
        }
    }

    private static void compressOfManifest(JarOutputStream out) throws IOException {
        byte[] data = ("Manifest-Version: 1.0\nPlatform: BSP\nBuildTime: " + new SimpleDateFormat("yyyy-MM-dd").format(new Date())).getBytes();
        JarEntry jarEntry = new JarEntry(MANIFEST_MF);
        out.putNextEntry(jarEntry);
        out.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void deCompressJar(String jarName, String filePath) throws Exception {
        block11: {
            file = new File(jarName);
            if (!file.exists()) {
                throw new Exception("The decompressed Jar package does not exist[" + file.getAbsolutePath() + "]");
            }
            FileUtil.openFileDir(filePath);
            jis = null;
            jis = new JarInputStream(new FileInputStream(file));
            while (true) lbl-1000:
            // 4 sources

            {
                if ((jarEntry = jis.getNextJarEntry()) == null) {
                    break block11;
                }
                if (jarEntry.isDirectory() || jarEntry.getName().equals("")) {
                    new File(filePath + "/" + jarEntry.getName()).mkdirs();
                    continue;
                }
                fos = null;
                try {
                    fos = FileUtil.openOutputStream(new File(filePath + "/" + jarEntry.getName()));
                    FileUtil.copyStream(jis, fos);
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (jis != null) {
                    jis.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressZip(String pathName, String zipName, boolean isRoot) throws Exception {
        FileOutputStream fos = null;
        try (ZipOutputStream out = null;){
            String root;
            fos = FileUtil.openOutputStream(new File(zipName));
            out = new ZipOutputStream(fos);
            File file = new File(pathName);
            String string = root = isRoot ? file.getName() + "/" : "";
            if (file.isDirectory()) {
                CompressUtil.zipDir(out, file, root);
            } else {
                CompressUtil.zipFile(out, file, "");
            }
        }
    }

    private static void zipDir(ZipOutputStream out, File file, String root) throws IOException {
        File[] files = file.listFiles();
        if (files.length < 1) {
            ZipEntry zipEntry = new ZipEntry(root + "/");
            out.putNextEntry(zipEntry);
            out.closeEntry();
        }
        for (int i = 0; i < files.length; ++i) {
            String tmpRoot = root;
            if (files[i].isDirectory()) {
                tmpRoot = tmpRoot + files[i].getName() + "/";
                CompressUtil.zipDir(out, files[i], tmpRoot);
                continue;
            }
            CompressUtil.zipFile(out, files[i], tmpRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(ZipOutputStream out, File file, String root) throws IOException {
        ZipEntry zipEntry = new ZipEntry(root + file.getName());
        out.putNextEntry(zipEntry);
        try (FileInputStream is = new FileInputStream(file);){
            FileUtil.copyStream(is, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void deCompressZip(String zipName, String filePath) throws Exception {
        block11: {
            file = new File(zipName);
            if (!file.exists()) {
                throw new Exception("The decompressed Zip package does not exist[" + file.getAbsolutePath() + "]");
            }
            FileUtil.openFileDir(filePath);
            zis = null;
            zis = new ZipInputStream(new FileInputStream(zipName));
            while (true) lbl-1000:
            // 4 sources

            {
                if ((zipEntry = zis.getNextEntry()) == null) {
                    break block11;
                }
                if (zipEntry.isDirectory() || zipEntry.getName().equals("")) {
                    new File(filePath + "/" + zipEntry.getName()).mkdirs();
                    continue;
                }
                fos = null;
                try {
                    fos = FileUtil.openOutputStream(new File(filePath + zipEntry.getName()));
                    FileUtil.copyStream(zis, fos);
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (zis != null) {
                    zis.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressGZip(String sourceFilePath, String gzipFilePath) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        DeflaterOutputStream gos = null;
        try {
            fis = FileUtil.openInputStream(new File(sourceFilePath));
            fos = FileUtil.openOutputStream(new File(gzipFilePath));
            gos = new GZIPOutputStream(fos);
            FileUtil.copyStream(fis, gos);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (gos != null) {
                gos.close();
            }
        }
    }

    public static byte[] compressGZipData(byte[] bytes) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (GZIPOutputStream gos = new GZIPOutputStream(bos);){
            gos.write(bytes);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressGZip(String gzipFilePath, String targetFilePath) throws IOException {
        FileInputStream fis = null;
        GZIPInputStream gis = null;
        FileOutputStream fos = null;
        try {
            fis = FileUtil.openInputStream(new File(gzipFilePath));
            gis = new GZIPInputStream(fis);
            fos = FileUtil.openOutputStream(new File(targetFilePath));
            FileUtil.copyStream(gis, fos);
        }
        finally {
            if (gis != null) {
                gis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deCompressGZipData(byte[] bytes) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        GZIPInputStream gis = new GZIPInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = null;
        try {
            byte[] buf = new byte[1024];
            int n = 0;
            while ((n = gis.read(buf)) != -1) {
                bos.write(buf, 0, n);
            }
            b = bos.toByteArray();
        }
        finally {
            bos.close();
            gis.close();
            bis.close();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressZipData(byte[] bytes) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ZipOutputStream zop = new ZipOutputStream(bos);){
            ZipEntry entry = new ZipEntry("zop");
            entry.setSize(bytes.length);
            zop.putNextEntry(entry);
            zop.write(bytes);
            zop.closeEntry();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deCompressZipData(byte[] bytes) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ZipInputStream zip = new ZipInputStream(bis);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = null;
        try {
            while (zip.getNextEntry() != null) {
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = zip.read(buf)) != -1) {
                    baos.write(buf, 0, n);
                }
            }
            byte[] byArray = b = baos.toByteArray();
            return byArray;
        }
        finally {
            baos.close();
            zip.close();
            bis.close();
        }
    }
}

